/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.RaftKeyNames;
import io.atomix.raft.metrics.RaftMetrics;
import io.atomix.raft.metrics.RaftRequestMetricsDoc;
import io.camunda.zeebe.util.collection.Table;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RaftRequestMetrics
extends RaftMetrics {
    private final Map<String, Counter> raftMessagesReceived = new ConcurrentHashMap<String, Counter>(32);
    private final MeterRegistry registry;
    private final Table<String, String, Counter> raftMessagesSend = Table.concurrent();

    public RaftRequestMetrics(String partitionName, MeterRegistry registry) {
        super(partitionName);
        this.registry = registry;
    }

    public void receivedMessage(String type) {
        this.getMessageReceived(type).increment();
    }

    public void sendMessage(String memberId, String type) {
        this.getMessageSent(memberId, type).increment();
    }

    private Counter getMessageReceived(String type) {
        return this.raftMessagesReceived.computeIfAbsent(type, tpe -> Counter.builder((String)RaftRequestMetricsDoc.RAFT_MESSAGE_RECEIVED.getName()).description(RaftRequestMetricsDoc.RAFT_MESSAGE_RECEIVED.getDescription()).tags(new String[]{RaftKeyNames.TYPE.asString(), type, RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName}).register(this.registry));
    }

    private Counter getMessageSent(String memberId, String type) {
        return (Counter)this.raftMessagesSend.computeIfAbsent((Object)memberId, (Object)type, (member, tpe) -> Counter.builder((String)RaftRequestMetricsDoc.RAFT_MESSAGE_SEND.getName()).description(RaftRequestMetricsDoc.RAFT_MESSAGE_SEND.getDescription()).tags(new String[]{RaftKeyNames.TO.asString(), member, RaftKeyNames.TYPE.asString(), tpe, RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName}).register(this.registry));
    }
}

