/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.utils.AbstractIdentifier;
import java.util.Objects;

public class PartitionId
extends AbstractIdentifier<Integer>
implements Comparable<PartitionId> {
    private final String group;

    public PartitionId(String group, int id) {
        super((Comparable)Integer.valueOf(id));
        this.group = (String)Preconditions.checkNotNull((Object)group, (Object)"group cannot be null");
        Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"partition id must be non-negative");
    }

    public static PartitionId from(String group, int id) {
        return new PartitionId(group, id);
    }

    @Override
    public int compareTo(PartitionId that) {
        return Integer.compare((Integer)this.identifier, (Integer)that.identifier);
    }

    public String group() {
        return this.group;
    }

    public int hashCode() {
        return Objects.hash(this.id(), this.group());
    }

    public boolean equals(Object object) {
        if (object instanceof PartitionId) {
            PartitionId partitionId = (PartitionId)object;
            return ((Integer)partitionId.id()).equals(this.id()) && partitionId.group().equals(this.group());
        }
        if (object instanceof AbstractIdentifier) {
            return object.equals(this);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id()).add("group", (Object)this.group).toString();
    }
}

