/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.utils;

import io.atomix.raft.utils.StateUtil;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateUtilTest {
    private static final Logger LOG = LoggerFactory.getLogger((String)"TEST");

    StateUtilTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"provideInconsistentState"})
    void shouldThrowException(RaftState state) {
        Assertions.assertThatException().isThrownBy(() -> StateUtil.verifySnapshotLogConsistent((long)1L, (long)state.snapshotIndex(), (long)state.firstIndex(), (boolean)state.isLogEmpty(), i -> {}, (Logger)LOG));
    }

    @ParameterizedTest
    @MethodSource(value={"provideConsistentStateWithNoNeedToResetLog"})
    void shouldNotThrowException(RaftState state) {
        AssertionsForClassTypes.assertThatNoException().isThrownBy(() -> StateUtil.verifySnapshotLogConsistent((long)1L, (long)state.snapshotIndex(), (long)state.firstIndex(), (boolean)state.isLogEmpty(), i -> {
            throw new RuntimeException("Expected not to call reset");
        }, (Logger)LOG));
    }

    @ParameterizedTest
    @MethodSource(value={"provideStateThatAreConsistentAfterLogReset"})
    void shouldResetLog(RaftState state) {
        CompletableFuture logReset = new CompletableFuture();
        AssertionsForClassTypes.assertThatNoException().isThrownBy(() -> StateUtil.verifySnapshotLogConsistent((long)1L, (long)state.snapshotIndex(), (long)state.firstIndex(), (boolean)state.isLogEmpty(), logReset::complete, (Logger)LOG));
        Assertions.assertThat(logReset).succeedsWithin(Duration.ofMillis(100L)).isEqualTo((Object)(state.snapshotIndex() + 1L));
    }

    private static Stream<Arguments> provideInconsistentState() {
        return Stream.of(Arguments.of((Object[])new Object[]{Named.of((String)"No snapshot before the log's first entry.", (Object)RaftState.of(0L, 5L, false))}), Arguments.of((Object[])new Object[]{Named.of((String)"Entries between snapshot and the first log entry are missing.(1)", (Object)RaftState.of(1L, 5L, false))}), Arguments.of((Object[])new Object[]{Named.of((String)"Entries between snapshot and the first log entry are missing.(2)", (Object)RaftState.of(3L, 6L, false))}));
    }

    private static Stream<Arguments> provideConsistentStateWithNoNeedToResetLog() {
        return Stream.of(Arguments.of((Object[])new Object[]{Named.of((String)"Follower receives a new snapshot, and restarted before receiving log entries.", (Object)RaftState.of(4L, 5L, true))}), Arguments.of((Object[])new Object[]{Named.of((String)"Follower receives a new snapshot, receives log entries and restarts", (Object)RaftState.of(4L, 5L, false))}), Arguments.of((Object[])new Object[]{Named.of((String)"Any node after compacting the log after snapshotting, First index = snapshotIndex", (Object)RaftState.of(5L, 5L, false))}), Arguments.of((Object[])new Object[]{Named.of((String)"Any node after compacting the log after snapshotting. First index < snapshotIndex", (Object)RaftState.of(6L, 5L, false))}), Arguments.of((Object[])new Object[]{Named.of((String)"Initial state", (Object)RaftState.of(0L, 1L, true))}), Arguments.of((Object[])new Object[]{Named.of((String)"State after appending log entries, with out snapshot", (Object)RaftState.of(0L, 1L, false))}));
    }

    private static Stream<Arguments> provideStateThatAreConsistentAfterLogReset() {
        return Stream.of(Arguments.of((Object[])new Object[]{Named.of((String)"Follower received first snapshot, reset the log, crash before committing snapshot.", (Object)RaftState.of(0L, 5L, true))}), Arguments.of((Object[])new Object[]{Named.of((String)"Follower received a newer snapshot, reset the logs, crash before committing snapshot.", (Object)RaftState.of(3L, 5L, true))}));
    }

    private record RaftState(long snapshotIndex, long firstIndex, boolean isLogEmpty) {
        static RaftState of(long snapshotIndex, long firstIndex, boolean isLogEmpty) {
            return new RaftState(snapshotIndex, firstIndex, isLogEmpty);
        }
    }
}

