/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.utils;

import io.atomix.cluster.MemberId;
import io.atomix.raft.utils.ForceConfigureQuorum;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ForceConfigureQuorumTest {
    private final MemberId id0 = MemberId.from((String)"0");
    private final MemberId id1 = MemberId.from((String)"1");
    private final MemberId id2 = MemberId.from((String)"2");
    private final Set<MemberId> members = Set.of(this.id0, this.id1, this.id2);

    ForceConfigureQuorumTest() {
    }

    @Test
    void shouldSucceedWhenAllAck() {
        AtomicBoolean success = new AtomicBoolean();
        ForceConfigureQuorum quorum = new ForceConfigureQuorum(success::set, this.members);
        this.members.forEach(arg_0 -> ((ForceConfigureQuorum)quorum).succeed(arg_0));
        Assertions.assertThat((AtomicBoolean)success).isTrue();
    }

    @Test
    void shouldFailWhenOneFails() {
        AtomicBoolean success = new AtomicBoolean();
        ForceConfigureQuorum quorum = new ForceConfigureQuorum(success::set, this.members);
        quorum.succeed(this.id0);
        quorum.succeed(this.id1);
        quorum.fail(this.id2);
        Assertions.assertThat((AtomicBoolean)success).isFalse();
    }

    @Test
    void shouldCallbackImmediatelyIfOneFailed() {
        CompletableFuture quorumFuture = new CompletableFuture();
        ForceConfigureQuorum quorum = new ForceConfigureQuorum(quorumFuture::complete, this.members);
        quorum.fail(this.id2);
        Assertions.assertThat((Boolean)((Boolean)quorumFuture.join())).isFalse();
    }
}

