/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.partition.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.raft.metrics.RaftRequestMetrics;
import io.atomix.raft.partition.impl.RaftMessageContext;
import io.atomix.raft.protocol.AppendRequest;
import io.atomix.raft.protocol.AppendResponse;
import io.atomix.raft.protocol.ConfigureRequest;
import io.atomix.raft.protocol.ConfigureResponse;
import io.atomix.raft.protocol.ForceConfigureRequest;
import io.atomix.raft.protocol.ForceConfigureResponse;
import io.atomix.raft.protocol.InstallRequest;
import io.atomix.raft.protocol.InstallResponse;
import io.atomix.raft.protocol.JoinRequest;
import io.atomix.raft.protocol.JoinResponse;
import io.atomix.raft.protocol.LeaveRequest;
import io.atomix.raft.protocol.LeaveResponse;
import io.atomix.raft.protocol.PollRequest;
import io.atomix.raft.protocol.PollResponse;
import io.atomix.raft.protocol.RaftMessage;
import io.atomix.raft.protocol.RaftServerProtocol;
import io.atomix.raft.protocol.ReconfigureRequest;
import io.atomix.raft.protocol.ReconfigureResponse;
import io.atomix.raft.protocol.TransferRequest;
import io.atomix.raft.protocol.TransferResponse;
import io.atomix.raft.protocol.VersionedAppendRequest;
import io.atomix.raft.protocol.VoteRequest;
import io.atomix.raft.protocol.VoteResponse;
import io.atomix.utils.serializer.Serializer;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class RaftServerCommunicator
implements RaftServerProtocol {
    private final RaftMessageContext context;
    private final Serializer serializer;
    private final ClusterCommunicationService clusterCommunicator;
    private final RaftRequestMetrics metrics;
    private final Duration requestTimeout;
    private final Duration snapshotRequestTimeout;
    private final Duration configurationChangeTimeout;

    public RaftServerCommunicator(String prefix, Serializer serializer, ClusterCommunicationService clusterCommunicator, Duration requestTimeout, Duration snapshotRequestTimeout, Duration configurationChangeTimeout, MeterRegistry meterRegistry) {
        this.context = new RaftMessageContext(prefix);
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        this.clusterCommunicator = (ClusterCommunicationService)Preconditions.checkNotNull((Object)clusterCommunicator, (Object)"clusterCommunicator cannot be null");
        this.requestTimeout = requestTimeout;
        this.snapshotRequestTimeout = snapshotRequestTimeout;
        this.configurationChangeTimeout = configurationChangeTimeout;
        this.metrics = new RaftRequestMetrics(prefix, meterRegistry);
    }

    @Override
    public CompletableFuture<ConfigureResponse> configure(MemberId memberId, ConfigureRequest request) {
        return this.sendAndReceive(this.context.configureSubject, request, memberId);
    }

    @Override
    public CompletableFuture<ReconfigureResponse> reconfigure(MemberId memberId, ReconfigureRequest request) {
        return this.sendAndReceive(this.context.reconfigureSubject, request, memberId, this.configurationChangeTimeout);
    }

    @Override
    public CompletableFuture<ForceConfigureResponse> forceConfigure(MemberId memberId, ForceConfigureRequest request) {
        return this.sendAndReceive(this.context.forceConfigureSubject, request, memberId, this.requestTimeout);
    }

    @Override
    public CompletableFuture<JoinResponse> join(MemberId memberId, JoinRequest request) {
        return this.sendAndReceive(this.context.joinSubject, request, memberId, this.configurationChangeTimeout);
    }

    @Override
    public CompletableFuture<LeaveResponse> leave(MemberId memberId, LeaveRequest request) {
        return this.sendAndReceive(this.context.leaveSubject, request, memberId, this.configurationChangeTimeout);
    }

    @Override
    public CompletableFuture<InstallResponse> install(MemberId memberId, InstallRequest request) {
        return this.sendAndReceive(this.context.installSubject, request, memberId, this.snapshotRequestTimeout);
    }

    @Override
    public CompletableFuture<TransferResponse> transfer(MemberId memberId, TransferRequest request) {
        return this.sendAndReceive(this.context.transferSubject, request, memberId);
    }

    @Override
    public CompletableFuture<PollResponse> poll(MemberId memberId, PollRequest request) {
        return this.sendAndReceive(this.context.pollSubject, request, memberId);
    }

    @Override
    public CompletableFuture<VoteResponse> vote(MemberId memberId, VoteRequest request) {
        return this.sendAndReceive(this.context.voteSubject, request, memberId);
    }

    @Override
    public CompletableFuture<AppendResponse> append(MemberId memberId, AppendRequest request) {
        return this.sendAndReceive(this.context.appendV1subject, request, memberId);
    }

    @Override
    public CompletableFuture<AppendResponse> append(MemberId memberId, VersionedAppendRequest request) {
        return this.sendAndReceive(this.context.appendV2subject, request, memberId);
    }

    @Override
    public void registerTransferHandler(Function<TransferRequest, CompletableFuture<TransferResponse>> handler) {
        this.clusterCommunicator.replyTo(this.context.transferSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler.compose(this::recordReceivedMetrics), arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterTransferHandler() {
        this.clusterCommunicator.unsubscribe(this.context.transferSubject);
    }

    @Override
    public void registerConfigureHandler(Function<ConfigureRequest, CompletableFuture<ConfigureResponse>> handler) {
        this.clusterCommunicator.replyTo(this.context.configureSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler.compose(this::recordReceivedMetrics), arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterConfigureHandler() {
        this.clusterCommunicator.unsubscribe(this.context.configureSubject);
    }

    @Override
    public void registerReconfigureHandler(Function<ReconfigureRequest, CompletableFuture<ReconfigureResponse>> handler) {
        this.clusterCommunicator.replyTo(this.context.reconfigureSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler.compose(this::recordReceivedMetrics), arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterReconfigureHandler() {
        this.clusterCommunicator.unsubscribe(this.context.reconfigureSubject);
    }

    @Override
    public void registerForceConfigureHandler(Function<ForceConfigureRequest, CompletableFuture<ForceConfigureResponse>> handler) {
        this.clusterCommunicator.replyTo(this.context.forceConfigureSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler.compose(this::recordReceivedMetrics), arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterForceConfigureHandler() {
        this.clusterCommunicator.unsubscribe(this.context.forceConfigureSubject);
    }

    @Override
    public void registerJoinHandler(Function<JoinRequest, CompletableFuture<JoinResponse>> handler) {
        this.clusterCommunicator.replyTo(this.context.joinSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler.compose(this::recordReceivedMetrics), arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterJoinHandler() {
        this.clusterCommunicator.unsubscribe(this.context.joinSubject);
    }

    @Override
    public void registerLeaveHandler(Function<LeaveRequest, CompletableFuture<LeaveResponse>> handler) {
        this.clusterCommunicator.replyTo(this.context.leaveSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler.compose(this::recordReceivedMetrics), arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterLeaveHandler() {
        this.clusterCommunicator.unsubscribe(this.context.leaveSubject);
    }

    @Override
    public void registerInstallHandler(Function<InstallRequest, CompletableFuture<InstallResponse>> handler) {
        this.clusterCommunicator.replyTo(this.context.installSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler.compose(this::recordReceivedMetrics), arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterInstallHandler() {
        this.clusterCommunicator.unsubscribe(this.context.installSubject);
    }

    @Override
    public void registerPollHandler(Function<PollRequest, CompletableFuture<PollResponse>> handler) {
        this.clusterCommunicator.replyTo(this.context.pollSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler.compose(this::recordReceivedMetrics), arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterPollHandler() {
        this.clusterCommunicator.unsubscribe(this.context.pollSubject);
    }

    @Override
    public void registerVoteHandler(Function<VoteRequest, CompletableFuture<VoteResponse>> handler) {
        this.clusterCommunicator.replyTo(this.context.voteSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler.compose(this::recordReceivedMetrics), arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterVoteHandler() {
        this.clusterCommunicator.unsubscribe(this.context.voteSubject);
    }

    @Override
    public void registerAppendV1Handler(Function<AppendRequest, CompletableFuture<AppendResponse>> handler) {
        this.clusterCommunicator.replyTo(this.context.appendV1subject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler.compose(this::recordReceivedMetrics), arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void registerAppendV2Handler(Function<VersionedAppendRequest, CompletableFuture<AppendResponse>> handler) {
        this.clusterCommunicator.replyTo(this.context.appendV2subject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler.compose(this::recordReceivedMetrics), arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterAppendHandler() {
        this.clusterCommunicator.unsubscribe(this.context.appendV1subject);
        this.clusterCommunicator.unsubscribe(this.context.appendV2subject);
    }

    private <T, U> CompletableFuture<U> sendAndReceive(String subject, T request, MemberId memberId) {
        return this.sendAndReceive(subject, request, memberId, this.requestTimeout);
    }

    private <T, U> CompletableFuture<U> sendAndReceive(String subject, T request, MemberId memberId, Duration timeout) {
        this.metrics.sendMessage((String)((Object)memberId.id()), request.getClass().getSimpleName());
        return this.clusterCommunicator.send(subject, request, arg_0 -> ((Serializer)this.serializer).encode(arg_0), arg_0 -> ((Serializer)this.serializer).decode(arg_0), memberId, timeout);
    }

    private <T extends RaftMessage> T recordReceivedMetrics(T m) {
        this.metrics.receivedMessage(m.getClass().getSimpleName());
        return m;
    }
}

