/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.MetaStoreMetricsDoc;
import io.atomix.raft.metrics.RaftKeyNames;
import io.atomix.raft.metrics.RaftMetrics;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Objects;

public final class MetaStoreMetrics
extends RaftMetrics {
    private final Timer lastFlushedIndexUpdate;
    private final Clock clock;

    public MetaStoreMetrics(String partitionName, MeterRegistry registry) {
        super(partitionName);
        Objects.requireNonNull(registry, "MeterRegistry cannot be null");
        this.lastFlushedIndexUpdate = Timer.builder((String)MetaStoreMetricsDoc.LAST_FLUSHED_INDEX.getName()).description(MetaStoreMetricsDoc.LAST_FLUSHED_INDEX.getDescription()).serviceLevelObjectives(MetaStoreMetricsDoc.LAST_FLUSHED_INDEX.getTimerSLOs()).tag(RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName).register(registry);
        this.clock = registry.config().clock();
    }

    public CloseableSilently observeLastFlushedIndexUpdate() {
        return MicrometerUtil.timer((Timer)this.lastFlushedIndexUpdate, (Timer.Sample)Timer.start((Clock)this.clock));
    }
}

