/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.LeaderMetricsDoc;
import io.atomix.raft.metrics.RaftKeyNames;
import io.atomix.raft.metrics.RaftMetrics;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.micrometer.StatefulGauge;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class LeaderAppenderMetrics
extends RaftMetrics
implements CloseableSilently {
    private final MeterRegistry meterRegistry;
    private final Map<String, Timer> appendLatency;
    private final Map<String, Counter> appendDataRate;
    private final Map<String, Counter> appendRate;
    private final Counter commitRate;
    private final StatefulGauge nonCommittedEntriesValue;
    private final Map<String, StatefulGauge> nonReplicatedEntries;

    public LeaderAppenderMetrics(String partitionName, MeterRegistry meterRegistry) {
        super(partitionName);
        this.meterRegistry = meterRegistry;
        this.appendLatency = new HashMap<String, Timer>();
        this.appendDataRate = new HashMap<String, Counter>();
        this.appendRate = new HashMap<String, Counter>();
        this.nonReplicatedEntries = new HashMap<String, StatefulGauge>();
        this.commitRate = Counter.builder((String)LeaderMetricsDoc.COMMIT_RATE.getName()).description(LeaderMetricsDoc.COMMIT_RATE.getDescription()).tag(RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName).register(meterRegistry);
        this.nonCommittedEntriesValue = StatefulGauge.builder((String)LeaderMetricsDoc.NON_COMMITTED_ENTRIES.getName()).description(LeaderMetricsDoc.NON_COMMITTED_ENTRIES.getDescription()).tag(RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName).register(meterRegistry);
    }

    public void appendComplete(long latencyms, String memberId) {
        this.getAppendLatency(memberId).record(latencyms, TimeUnit.MILLISECONDS);
    }

    public void observeAppend(String memberId, int appendedEntries, int appendedBytes) {
        this.getAppendRate(memberId).increment((double)appendedEntries);
        this.getAppendDataRate(memberId).increment((double)((float)appendedBytes / 1024.0f));
    }

    public void observeCommit() {
        this.commitRate.increment();
    }

    public void observeNonCommittedEntries(long remainingEntries) {
        this.nonCommittedEntriesValue.set(remainingEntries);
    }

    public void observeRemainingEntries(String memberId, long remainingEntries) {
        this.nonReplicatedEntries.computeIfAbsent(memberId, this::registerNonReplicatedEntries).set(remainingEntries);
    }

    private Timer getAppendLatency(String memberId) {
        return this.appendLatency.computeIfAbsent(memberId, id -> Timer.builder((String)LeaderMetricsDoc.APPEND_ENTRIES_LATENCY.getName()).description(LeaderMetricsDoc.APPEND_ENTRIES_LATENCY.getDescription()).serviceLevelObjectives(LeaderMetricsDoc.APPEND_ENTRIES_LATENCY.getTimerSLOs()).tags(new String[]{RaftKeyNames.FOLLOWER.asString(), memberId, RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName}).register(this.meterRegistry));
    }

    private Counter getAppendDataRate(String memberId) {
        return this.appendDataRate.computeIfAbsent(memberId, id -> Counter.builder((String)LeaderMetricsDoc.APPEND_DATA_RATE.getName()).description(LeaderMetricsDoc.APPEND_DATA_RATE.getDescription()).tags(new String[]{RaftKeyNames.FOLLOWER.asString(), id, RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName}).register(this.meterRegistry));
    }

    private Counter getAppendRate(String memberId) {
        return this.appendRate.computeIfAbsent(memberId, id -> Counter.builder((String)LeaderMetricsDoc.APPEND_RATE.getName()).description(LeaderMetricsDoc.APPEND_RATE.getDescription()).tags(new String[]{RaftKeyNames.FOLLOWER.asString(), id, RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName}).register(this.meterRegistry));
    }

    private StatefulGauge registerNonReplicatedEntries(String memberId) {
        return StatefulGauge.builder((String)LeaderMetricsDoc.NON_REPLICATED_ENTRIES.getName()).description(LeaderMetricsDoc.NON_REPLICATED_ENTRIES.getDescription()).tag(RaftKeyNames.FOLLOWER.asString(), memberId).tag(RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName).register(this.meterRegistry);
    }

    public void close() {
        this.meterRegistry.remove((Meter)this.commitRate);
        this.meterRegistry.remove((Meter)this.nonCommittedEntriesValue);
        this.appendLatency.values().forEach(arg_0 -> ((MeterRegistry)this.meterRegistry).remove(arg_0));
        this.appendRate.values().forEach(arg_0 -> ((MeterRegistry)this.meterRegistry).remove(arg_0));
        this.appendDataRate.values().forEach(arg_0 -> ((MeterRegistry)this.meterRegistry).remove(arg_0));
        this.nonReplicatedEntries.values().forEach(arg_0 -> ((MeterRegistry)this.meterRegistry).remove(arg_0));
    }
}

