/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log;

import io.atomix.raft.storage.log.DelayedFlusher;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.concurrent.Scheduler;
import io.camunda.zeebe.journal.Journal;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.agrona.CloseHelper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

final class DelayedFlusherTest {
    private final TestScheduler scheduler = new TestScheduler();
    private final DelayedFlusher flusher = new DelayedFlusher((Scheduler)this.scheduler, Duration.ofSeconds(5L));

    DelayedFlusherTest() {
    }

    @AfterEach
    void afterEach() {
        CloseHelper.quietClose((AutoCloseable)this.flusher);
    }

    @Test
    void shouldDelayFlushByInterval() {
        Journal journal = (Journal)Mockito.mock(Journal.class);
        Mockito.when((Object)journal.isOpen()).thenReturn((Object)true);
        this.flusher.flush(journal);
        Assertions.assertThat(this.scheduler.operations).hasSize(1);
        TestScheduled scheduled = this.scheduler.operations.get(0);
        Assertions.assertThat((Object)scheduled).extracting(new Function[]{t -> t.initialDelay, t -> t.interval}).containsExactly(new Object[]{Duration.ZERO, Duration.ofSeconds(5L)});
        ((Journal)Mockito.verify((Object)journal, (VerificationMode)Mockito.never())).flush();
    }

    @Test
    void shouldFlushWhenScheduledTaskIsRun() {
        Journal journal = (Journal)Mockito.mock(Journal.class);
        Mockito.when((Object)journal.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)journal.getLastIndex()).thenReturn((Object)5L);
        this.flusher.flush(journal);
        this.scheduler.runNext();
        ((Journal)Mockito.verify((Object)journal, (VerificationMode)Mockito.times((int)1))).flush();
    }

    @Test
    void shouldNotScheduleIfAlreadyScheduled() {
        Journal journal = (Journal)Mockito.mock(Journal.class);
        Mockito.when((Object)journal.getLastIndex()).thenReturn((Object)5L);
        this.flusher.flush(journal);
        this.flusher.flush(journal);
        this.flusher.flush(journal);
        Assertions.assertThat(this.scheduler.operations).hasSize(1);
        TestScheduled scheduled = this.scheduler.operations.get(0);
        Assertions.assertThat((Object)scheduled).extracting(new Function[]{t -> t.initialDelay, t -> t.interval}).containsExactly(new Object[]{Duration.ZERO, Duration.ofSeconds(5L)});
    }

    @Test
    void shouldCancelScheduledFlushOnClose() {
        Journal journal = (Journal)Mockito.mock(Journal.class);
        this.flusher.flush(journal);
        this.flusher.close();
        TestScheduled scheduled = this.scheduler.operations.get(0);
        Assertions.assertThat((boolean)scheduled.cancelled).isTrue();
    }

    @Test
    void shouldNotScheduleFlushWhenClosed() {
        Journal journal = (Journal)Mockito.mock(Journal.class);
        Mockito.when((Object)journal.isOpen()).thenReturn((Object)true);
        this.flusher.close();
        this.flusher.flush(journal);
        Assertions.assertThat(this.scheduler.operations).isEmpty();
    }

    @Test
    void shouldRescheduleOnFlushError() {
        Journal journal = (Journal)Mockito.mock(Journal.class);
        ((Journal)Mockito.doThrow((Throwable[])new Throwable[]{new UncheckedIOException(new IOException("Cannot allocate memory"))}).when((Object)journal)).flush();
        this.flusher.flush(journal);
        this.scheduler.runNext();
        ((Journal)Mockito.doNothing().when((Object)journal)).flush();
        this.scheduler.runNext();
        ((Journal)Mockito.verify((Object)journal, (VerificationMode)Mockito.times((int)2))).flush();
    }

    @Test
    void shouldNotRescheduleOnFlushErrorIfClosed() {
        Journal journal = (Journal)Mockito.mock(Journal.class);
        ((Journal)Mockito.doThrow((Throwable[])new Throwable[]{new UncheckedIOException(new IOException("Cannot allocate memory"))}).when((Object)journal)).flush();
        this.flusher.flush(journal);
        this.flusher.close();
        this.scheduler.runNext();
        Assertions.assertThat(this.scheduler.operations).isEmpty();
    }

    private static final class TestScheduler
    implements Scheduler {
        private final List<TestScheduled> operations = new ArrayList<TestScheduled>();

        private TestScheduler() {
        }

        public Scheduled schedule(Duration initialDelay, Duration interval, Runnable callback) {
            TestScheduled scheduled = new TestScheduled(initialDelay, interval, callback);
            this.operations.add(scheduled);
            return scheduled;
        }

        private void runNext() {
            this.operations.remove((int)0).operation.run();
        }
    }

    private static final class TestScheduled
    implements Scheduled {
        private final Duration initialDelay;
        private final Duration interval;
        private final Runnable operation;
        private boolean cancelled;

        private TestScheduled(Duration initialDelay, Duration interval, Runnable operation) {
            this.initialDelay = initialDelay;
            this.interval = interval;
            this.operation = operation;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public boolean isDone() {
            return this.cancelled;
        }
    }
}

