/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.impl;

import io.atomix.raft.impl.LogCompactor;
import io.atomix.raft.metrics.RaftServiceMetrics;
import io.atomix.raft.snapshot.InMemorySnapshot;
import io.atomix.raft.snapshot.TestSnapshotStore;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.utils.concurrent.ThreadContext;
import io.camunda.zeebe.snapshots.PersistedSnapshotStore;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.AutoClose;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;

final class LogCompactorTest {
    private ThreadContext threadContext;
    private RaftLog raftLog;
    private LogCompactor compactor;
    @AutoClose
    private final MeterRegistry meterRegistry = new SimpleMeterRegistry();

    LogCompactorTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.threadContext = (ThreadContext)Mockito.mock(ThreadContext.class);
        this.raftLog = (RaftLog)Mockito.mock(RaftLog.class);
        ((ThreadContext)Mockito.doAnswer(i -> {
            ((Runnable)i.getArgument(0, Runnable.class)).run();
            return null;
        }).when((Object)this.threadContext)).execute((Runnable)Mockito.any());
        this.compactor = new LogCompactor(this.threadContext, this.raftLog, 5, new RaftServiceMetrics("1", this.meterRegistry), LoggerFactory.getLogger(this.getClass()));
    }

    @Test
    void shouldCompact() {
        this.compactor.setCompactableIndex(12L);
        this.compactor.compact();
        ((RaftLog)Mockito.verify((Object)this.raftLog, (VerificationMode)Mockito.times((int)1).description("should compact up to index minus the replication threshold"))).deleteUntil(7L);
    }

    @Test
    void shouldCompactIgnoringThreshold() {
        this.compactor.setCompactableIndex(12L);
        this.compactor.compactIgnoringReplicationThreshold();
        ((RaftLog)Mockito.verify((Object)this.raftLog, (VerificationMode)Mockito.times((int)1).description("should compact until compactable index"))).deleteUntil(12L);
    }

    @ParameterizedTest
    @MethodSource(value={"provideCompactors"})
    void shouldNotCompactOnDifferentThread(Consumer<LogCompactor> compactMethod) {
        ((ThreadContext)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Invalid thread")}).when((Object)this.threadContext)).checkThread();
        this.compactor.setCompactableIndex(12L);
        AssertionsForClassTypes.assertThatCode(() -> compactMethod.accept(this.compactor)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void shouldCompactBasedOnOldestSnapshot() {
        TestSnapshotStore store = new TestSnapshotStore(new AtomicReference<InMemorySnapshot>());
        InMemorySnapshot.newPersistedSnapshot(0, 10L, 1L, 30, store).reserve();
        InMemorySnapshot.newPersistedSnapshot(0, 30L, 1L, 30, store);
        this.compactor.compactFromSnapshots((PersistedSnapshotStore)store);
        ((RaftLog)Mockito.verify((Object)this.raftLog, (VerificationMode)Mockito.times((int)1).description("should compact up to lowest snapshot index, minus replication threshold"))).deleteUntil(Mockito.eq((long)5L));
    }

    private static Stream<Named<Consumer<LogCompactor>>> provideCompactors() {
        return Stream.of(Named.of((String)"#compact", LogCompactor::compact), Named.of((String)"#compactIgnoringReplicationThreshold", LogCompactor::compactIgnoringReplicationThreshold));
    }
}

