/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import com.google.common.collect.Maps;
import io.atomix.cluster.messaging.ManagedUnicastService;
import io.atomix.cluster.messaging.impl.TestUnicastService;
import io.atomix.utils.net.Address;
import java.util.Map;

public class TestUnicastServiceFactory {
    private final Map<Address, TestUnicastService> services = Maps.newConcurrentMap();

    public void partition(Address address) {
        TestUnicastService service = this.services.get(address);
        this.services.values().stream().filter(s -> !s.address().equals((Object)address)).forEach(s -> {
            service.partition(s.address());
            s.partition(service.address());
        });
    }

    public void heal(Address address) {
        TestUnicastService service = this.services.get(address);
        this.services.values().stream().filter(s -> !s.address().equals((Object)address)).forEach(s -> {
            service.heal(s.address());
            s.heal(service.address());
        });
    }

    public void partition(Address address1, Address address2) {
        TestUnicastService service1 = this.services.get(address1);
        TestUnicastService service2 = this.services.get(address2);
        service1.partition(service2.address());
        service2.partition(service1.address());
    }

    public void heal(Address address1, Address address2) {
        TestUnicastService service1 = this.services.get(address1);
        TestUnicastService service2 = this.services.get(address2);
        service1.heal(service2.address());
        service2.heal(service1.address());
    }

    public ManagedUnicastService newUnicastService(Address address) {
        return new TestUnicastService(address, this.services);
    }
}

