/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.impl.MessageDecoderV1;
import io.atomix.cluster.messaging.impl.MessageEncoderV1;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;

public class MessageDecoderV1Test {
    @Test
    public void testDecodeCompactInt() throws Exception {
        ByteBuf buffer = Unpooled.buffer((int)5);
        MessageEncoderV1.writeInt((ByteBuf)buffer, (int)10);
        Assert.assertEquals((long)10L, (long)MessageDecoderV1.readInt((ByteBuf)buffer));
        buffer = Unpooled.buffer((int)2);
        MessageEncoderV1.writeInt((ByteBuf)buffer, (int)10);
        Assert.assertEquals((long)10L, (long)MessageDecoderV1.readInt((ByteBuf)buffer));
    }

    @Test
    public void testDecodeCompactLong() throws Exception {
        ByteBuf buffer = Unpooled.buffer((int)9);
        MessageEncoderV1.writeLong((ByteBuf)buffer, (long)10L);
        Assert.assertEquals((long)10L, (long)MessageDecoderV1.readLong((ByteBuf)buffer));
        buffer = Unpooled.buffer((int)2);
        MessageEncoderV1.writeLong((ByteBuf)buffer, (long)10L);
        Assert.assertEquals((long)10L, (long)MessageDecoderV1.readLong((ByteBuf)buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadStringFromHeapBuffer() throws Exception {
        String payload = "huuhaa";
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])"huuhaa".getBytes(StandardCharsets.UTF_8));
        try {
            Assert.assertEquals((Object)"huuhaa", (Object)MessageDecoderV1.readString((ByteBuf)byteBuf, (int)"huuhaa".length()));
        }
        finally {
            byteBuf.release();
        }
        byte[] bytes = "huuhaa".getBytes(StandardCharsets.UTF_8);
        byteBuf = Unpooled.buffer((int)(4 + bytes.length));
        try {
            byteBuf.writeInt(1);
            byteBuf.writeBytes(bytes);
            byteBuf.readInt();
            Assert.assertEquals((Object)"huuhaa", (Object)MessageDecoderV1.readString((ByteBuf)byteBuf, (int)"huuhaa".length()));
        }
        finally {
            byteBuf.release();
        }
    }

    @Test
    public void testReadStringFromDirectBuffer() throws Exception {
        String payload = "huuhaa";
        ByteBuf byteBuf = Unpooled.directBuffer((int)"huuhaa".length()).writeBytes("huuhaa".getBytes(StandardCharsets.UTF_8));
        try {
            Assert.assertEquals((Object)"huuhaa", (Object)MessageDecoderV1.readString((ByteBuf)byteBuf, (int)"huuhaa".length()));
        }
        finally {
            byteBuf.release();
        }
    }
}

