/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.impl.ChannelPool;
import io.atomix.utils.net.Address;
import io.netty.channel.Channel;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ChannelPoolTest {
    private static final String MESSAGE_TYPE = "test";
    private final Function<Address, CompletableFuture<Channel>> factory = a -> {
        Channel channel = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)channel.isActive()).thenReturn((Object)true);
        return CompletableFuture.completedFuture(channel);
    };
    private final ChannelPool channelPool = new ChannelPool(this.factory);

    ChannelPoolTest() {
    }

    @Test
    void shouldNotUseOldChannelWhenIPChanged() throws UnknownHostException {
        Address addressWithOldIP = new Address("foo.bar", 1234, InetAddress.getByName("10.1.1.1"));
        Channel channelForOldIP = (Channel)this.channelPool.getChannel(addressWithOldIP, MESSAGE_TYPE).join();
        Address addressWithNewIP = new Address("foo.bar", 1234, InetAddress.getByName("10.1.1.2"));
        Channel channelForNewIP = (Channel)this.channelPool.getChannel(addressWithNewIP, MESSAGE_TYPE).join();
        Assertions.assertThat((Comparable)channelForOldIP).isNotEqualTo((Object)channelForNewIP);
    }

    @Test
    void shouldNotUseIncorrectChannelWhenIPReused() throws UnknownHostException {
        Address nodeWithSameIP = new Address("foo.bar", 1234, InetAddress.getByName("10.1.1.1"));
        Channel channelForOldNode = (Channel)this.channelPool.getChannel(nodeWithSameIP, MESSAGE_TYPE).join();
        Address newNodeWithSameIP = new Address("foo.foo", 1234, InetAddress.getByName("10.1.1.1"));
        Channel channelForNewNode = (Channel)this.channelPool.getChannel(newNodeWithSameIP, MESSAGE_TYPE).join();
        Assertions.assertThat((Comparable)channelForOldNode).isNotEqualTo((Object)channelForNewNode);
    }
}

