/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log;

import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.IndexedRaftLogEntryImpl;
import io.atomix.raft.storage.log.RaftLogReader;
import io.atomix.raft.storage.log.entry.RaftLogEntry;
import io.atomix.raft.storage.serializer.RaftEntrySBESerializer;
import io.atomix.raft.storage.serializer.RaftEntrySerializer;
import io.camunda.zeebe.journal.JournalReader;
import io.camunda.zeebe.journal.JournalRecord;
import java.util.NoSuchElementException;

public class RaftLogUncommittedReader
implements RaftLogReader {
    private final JournalReader journalReader;
    private final RaftEntrySerializer serializer = new RaftEntrySBESerializer();

    RaftLogUncommittedReader(JournalReader journalReader) {
        this.journalReader = journalReader;
    }

    @Override
    public boolean hasNext() {
        return this.journalReader.hasNext();
    }

    @Override
    public IndexedRaftLogEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        JournalRecord journalRecord = (JournalRecord)this.journalReader.next();
        RaftLogEntry entry = this.serializer.readRaftLogEntry(journalRecord.data());
        return new IndexedRaftLogEntryImpl(entry.term(), entry.entry(), journalRecord);
    }

    @Override
    public long reset() {
        return this.journalReader.seekToFirst();
    }

    @Override
    public long seek(long index) {
        return this.journalReader.seek(index);
    }

    @Override
    public long seekToLast() {
        return this.journalReader.seekToLast();
    }

    @Override
    public long seekToAsqn(long asqn) {
        return this.journalReader.seekToAsqn(asqn);
    }

    @Override
    public void close() {
        this.journalReader.close();
    }

    public long seekToAsqn(long asqn, long indexUpperBound) {
        return this.journalReader.seekToAsqn(asqn, indexUpperBound);
    }
}

