/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.RaftKeyNames;
import io.atomix.raft.metrics.RaftMetrics;
import io.atomix.raft.metrics.RaftStartupMetricsDoc;
import io.camunda.zeebe.util.micrometer.StatefulGauge;
import io.micrometer.core.instrument.MeterRegistry;

public class RaftStartupMetrics
extends RaftMetrics {
    private final StatefulGauge bootstrapDuration;
    private final StatefulGauge joinDuration;

    public RaftStartupMetrics(String partitionName, MeterRegistry registry) {
        super(partitionName);
        this.bootstrapDuration = StatefulGauge.builder((String)RaftStartupMetricsDoc.BOOTSTRAP_DURATION.getName()).description(RaftStartupMetricsDoc.BOOTSTRAP_DURATION.getDescription()).tag(RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName).register(registry);
        this.joinDuration = StatefulGauge.builder((String)RaftStartupMetricsDoc.JOIN_DURATION.getName()).description(RaftStartupMetricsDoc.JOIN_DURATION.getDescription()).tag(RaftKeyNames.PARTITION_GROUP.asString(), this.partitionGroupName).register(registry);
    }

    public void observeBootstrapDuration(long durationMillis) {
        this.bootstrapDuration.set(durationMillis);
    }

    public void observeJoinDuration(long durationMillis) {
        this.joinDuration.set(durationMillis);
    }
}

