/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.impl.MessagingMetrics;
import io.atomix.cluster.messaging.impl.MessagingMetricsDoc;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.collection.Map3D;
import io.camunda.zeebe.util.collection.Table;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class MessagingMetricsImpl
implements MessagingMetrics {
    private final Map<String, Timer> requestResponseLatency;
    private final MeterRegistry registry;
    private final Table<String, String, DistributionSummary> requestSize;
    private final Table<String, String, Counter> requestMessageCounter;
    private final Table<String, String, Counter> requestRespCounter;
    private final Map3D<String, String, String, Counter> responseCounter;
    private final Table<String, String, Counter> inFlightCounter;

    MessagingMetricsImpl(MeterRegistry registry) {
        this.registry = registry;
        this.requestResponseLatency = new ConcurrentHashMap<String, Timer>();
        this.requestSize = Table.concurrent();
        this.requestMessageCounter = Table.concurrent();
        this.requestRespCounter = Table.concurrent();
        this.responseCounter = Map3D.concurrent();
        this.inFlightCounter = Table.concurrent();
    }

    @Override
    public CloseableSilently startRequestTimer(String name) {
        Timer timer = this.getReqRespLatency(name);
        return MicrometerUtil.timer((Timer)timer, (Timer.Sample)Timer.start((Clock)this.registry.config().clock()));
    }

    @Override
    public void observeRequestSize(String to, String name, int requestSizeInBytes) {
        this.getRequestSizeSummary(to, name).record((double)((float)requestSizeInBytes / 1000.0f));
    }

    @Override
    public void countMessage(String to, String name) {
        ((Counter)this.requestMessageCounter.computeIfAbsent((Object)to, (Object)name, (t, n) -> this.registerRequestCounter(MessageType.MESSAGE, (String)t, (String)n))).increment();
    }

    @Override
    public void countRequestResponse(String to, String name) {
        ((Counter)this.requestRespCounter.computeIfAbsent((Object)to, (Object)name, (t, n) -> this.registerRequestCounter(MessageType.REQ_RESP, (String)t, (String)n))).increment();
    }

    @Override
    public void countSuccessResponse(String address, String name) {
        ((Counter)this.responseCounter.computeIfAbsent((Object)address, (Object)name, (Object)"SUCCESS", this::registerResponseCounter)).increment();
    }

    @Override
    public void countFailureResponse(String address, String name, String error) {
        ((Counter)this.responseCounter.computeIfAbsent((Object)address, (Object)name, (Object)error, this::registerResponseCounter)).increment();
    }

    @Override
    public void incInFlightRequests(String address, String topic) {
        ((Counter)this.inFlightCounter.computeIfAbsent((Object)address, (Object)topic, this::registerInFlightCounter)).increment();
    }

    @Override
    public void decInFlightRequests(String address, String topic) {
        ((Counter)this.inFlightCounter.computeIfAbsent((Object)address, (Object)topic, this::registerInFlightCounter)).increment(-1.0);
    }

    private DistributionSummary getRequestSizeSummary(String to, String name) {
        return (DistributionSummary)this.requestSize.computeIfAbsent((Object)to, (Object)name, (t, n) -> DistributionSummary.builder((String)MessagingMetricsDoc.REQUEST_SIZE_IN_KB.getName()).description(MessagingMetricsDoc.REQUEST_SIZE_IN_KB.getDescription()).serviceLevelObjectives(MessagingMetricsDoc.REQUEST_SIZE_IN_KB.getDistributionSLOs()).tags(new String[]{MessagingMetricsDoc.MessagingKeyNames.ADDRESS.asString(), to, MessagingMetricsDoc.MessagingKeyNames.TOPIC.asString(), name}).register(this.registry));
    }

    private Timer getReqRespLatency(String topic) {
        return this.requestResponseLatency.computeIfAbsent(topic, t -> Timer.builder((String)MessagingMetricsDoc.REQUEST_RESPONSE_LATENCY.getName()).description(MessagingMetricsDoc.REQUEST_RESPONSE_LATENCY.getDescription()).serviceLevelObjectives(MessagingMetricsDoc.REQUEST_RESPONSE_LATENCY.getTimerSLOs()).tag(MessagingMetricsDoc.MessagingKeyNames.TOPIC.asString(), t).register(this.registry));
    }

    private Counter registerRequestCounter(MessageType type, String address, String topic) {
        return Counter.builder((String)MessagingMetricsDoc.REQUEST_COUNT.getName()).description(MessagingMetricsDoc.REQUEST_COUNT.getDescription()).tags(new String[]{MessagingMetricsDoc.MessagingKeyNames.TYPE.asString(), type.name(), MessagingMetricsDoc.MessagingKeyNames.ADDRESS.asString(), address, MessagingMetricsDoc.MessagingKeyNames.TOPIC.asString(), topic}).register(this.registry);
    }

    private Counter registerResponseCounter(String address, String topic, String outcome) {
        return Counter.builder((String)MessagingMetricsDoc.RESPONSE_COUNT.getName()).description(MessagingMetricsDoc.RESPONSE_COUNT.getDescription()).tags(new String[]{MessagingMetricsDoc.MessagingKeyNames.OUTCOME.asString(), outcome, MessagingMetricsDoc.MessagingKeyNames.ADDRESS.asString(), address, MessagingMetricsDoc.MessagingKeyNames.TOPIC.asString(), topic}).register(this.registry);
    }

    private Counter registerInFlightCounter(String address, String topic) {
        return Counter.builder((String)MessagingMetricsDoc.IN_FLIGHT_REQUESTS.getName()).description(MessagingMetricsDoc.IN_FLIGHT_REQUESTS.getDescription()).tags(new String[]{MessagingMetricsDoc.MessagingKeyNames.ADDRESS.asString(), address, MessagingMetricsDoc.MessagingKeyNames.TOPIC.asString(), topic}).register(this.registry);
    }

    private static enum MessageType {
        MESSAGE,
        REQ_RESP;

    }
}

