/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;

public enum MessagingMetricsDoc implements ExtendedMeterDocumentation
{
    REQUEST_RESPONSE_LATENCY{

        public String getName() {
            return "zeebe.messaging.request.response.latency";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MessagingKeyNames.TOPIC};
        }

        public String getDescription() {
            return "The time how long it takes to retrieve a response for a request";
        }

        public String getBaseUnit() {
            return "ms";
        }
    }
    ,
    REQUEST_SIZE_IN_KB{

        public String getName() {
            return "zeebe.messaging.request.size.kb";
        }

        public Meter.Type getType() {
            return Meter.Type.DISTRIBUTION_SUMMARY;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MessagingKeyNames.ADDRESS, MessagingKeyNames.TOPIC};
        }

        public String getDescription() {
            return "The size of the request, which has been sent";
        }

        public String getBaseUnit() {
            return "KB";
        }

        public double[] getDistributionSLOs() {
            return new double[]{0.01, 0.1, 0.25, 1.0, 10.0, 100.0, 500.0, 1000.0, 2000.0, 4000.0};
        }
    }
    ,
    REQUEST_COUNT{

        public String getName() {
            return "zeebe.messaging.request.count";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MessagingKeyNames.TYPE, MessagingKeyNames.ADDRESS, MessagingKeyNames.TOPIC};
        }

        public String getDescription() {
            return "Number of requests which has been sent to a certain address";
        }
    }
    ,
    RESPONSE_COUNT{

        public String getName() {
            return "zeebe.messaging.response.count";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MessagingKeyNames.ADDRESS, MessagingKeyNames.TOPIC, MessagingKeyNames.OUTCOME};
        }

        public String getDescription() {
            return "Number of responses which has been sent to a certain address";
        }
    }
    ,
    IN_FLIGHT_REQUESTS{

        public String getName() {
            return "zeebe.messaging.inflight.requests";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{MessagingKeyNames.ADDRESS, MessagingKeyNames.TOPIC};
        }

        public String getDescription() {
            return "The count of inflight requests";
        }
    };


    static enum MessagingKeyNames implements KeyName
    {
        TOPIC{

            public String asString() {
                return "topic";
            }
        }
        ,
        ADDRESS{

            public String asString() {
                return "address";
            }
        }
        ,
        TYPE{

            public String asString() {
                return "type";
            }
        }
        ,
        OUTCOME{

            public String asString() {
                return "outcome";
            }
        };

    }
}

