/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.snapshot;

import io.atomix.raft.snapshot.TestSnapshotChunkImpl;
import io.atomix.raft.snapshot.TestSnapshotStore;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.ReceivedSnapshot;
import io.camunda.zeebe.snapshots.SnapshotChunk;
import io.camunda.zeebe.snapshots.SnapshotChunkReader;
import io.camunda.zeebe.snapshots.SnapshotId;
import io.camunda.zeebe.snapshots.SnapshotMetadata;
import io.camunda.zeebe.snapshots.SnapshotReservation;
import io.camunda.zeebe.util.StringUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.zip.CRC32C;
import java.util.zip.Checksum;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class InMemorySnapshot
implements PersistedSnapshot,
ReceivedSnapshot {
    private final TestSnapshotStore testSnapshotStore;
    private final long index;
    private final long term;
    private final String id;
    private final NavigableMap<String, String> chunks = new TreeMap<String, String>();
    private final Checksum checksumCalculator = new CRC32C();
    private final Set<SnapshotReservation> reservations = new CopyOnWriteArraySet<SnapshotReservation>();
    private long checksum;

    InMemorySnapshot(TestSnapshotStore testSnapshotStore, String snapshotId) {
        this.testSnapshotStore = testSnapshotStore;
        this.id = snapshotId;
        String[] parts = snapshotId.split("-");
        this.index = Long.parseLong(parts[0]);
        this.term = Long.parseLong(parts[1]);
    }

    InMemorySnapshot(TestSnapshotStore testSnapshotStore, long index, long term, int nodeId) {
        this.testSnapshotStore = testSnapshotStore;
        this.index = index;
        this.term = term;
        this.id = String.format("%d-%d-%d", index, term, nodeId);
    }

    public static InMemorySnapshot newPersistedSnapshot(int nodeId, long index, long term, int size, TestSnapshotStore snapshotStore) {
        InMemorySnapshot snapshot = new InMemorySnapshot(snapshotStore, index, term, nodeId);
        for (int i = 0; i < size; ++i) {
            snapshot.writeChunks("chunk-" + i, ("test-" + i).getBytes());
        }
        snapshot.persist();
        return snapshot;
    }

    void writeChunks(String id, byte[] chunk) {
        this.chunks.put(id, StringUtil.fromBytes((byte[])chunk));
        this.checksumCalculator.update(chunk);
    }

    public int version() {
        return 1;
    }

    public long getIndex() {
        return this.index;
    }

    public long getTerm() {
        return this.term;
    }

    public SnapshotChunkReader newChunkReader() {
        return new SnapshotChunkReader(){
            private NavigableMap<String, String> iterator;
            {
                this.iterator = InMemorySnapshot.this.chunks;
            }

            public void reset() {
                this.iterator = InMemorySnapshot.this.chunks;
            }

            public void seek(ByteBuffer id) {
                String chunkId = BufferUtil.bufferAsString((DirectBuffer)new UnsafeBuffer(id));
                this.iterator = InMemorySnapshot.this.chunks.tailMap(chunkId, true);
            }

            public ByteBuffer nextId() {
                if (!this.hasNext()) {
                    return null;
                }
                return ByteBuffer.wrap(this.iterator.firstEntry().getKey().getBytes());
            }

            public void setMaximumChunkSize(int maximumChunkSize) {
            }

            public void close() {
                this.iterator = null;
            }

            public boolean hasNext() {
                return !this.iterator.isEmpty();
            }

            public SnapshotChunk next() {
                Map.Entry<String, String> nextEntry = this.iterator.firstEntry();
                this.iterator = InMemorySnapshot.this.chunks.tailMap(nextEntry.getKey(), false);
                return new TestSnapshotChunkImpl(InMemorySnapshot.this.id, nextEntry.getKey(), StringUtil.getBytes((String)nextEntry.getValue()), InMemorySnapshot.this.chunks.size());
            }
        };
    }

    public Path getPath() {
        return null;
    }

    public Path getChecksumPath() {
        return null;
    }

    public long getCompactionBound() {
        return this.index;
    }

    public String getId() {
        return this.id;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public SnapshotMetadata getMetadata() {
        return null;
    }

    public ActorFuture<SnapshotReservation> reserve() {
        SnapshotReservation reservation = new SnapshotReservation(){

            public ActorFuture<Void> release() {
                InMemorySnapshot.this.reservations.remove(this);
                return CompletableActorFuture.completed(null);
            }
        };
        this.reservations.add(reservation);
        return CompletableActorFuture.completed((Object)reservation);
    }

    boolean isReserved() {
        return !this.reservations.isEmpty();
    }

    public long index() {
        return this.index;
    }

    public ActorFuture<Void> apply(SnapshotChunk chunk) {
        this.chunks.put(chunk.getChunkName(), StringUtil.fromBytes((byte[])chunk.getContent()));
        return CompletableActorFuture.completed(null);
    }

    public ActorFuture<Void> abort() {
        return CompletableActorFuture.completed(null);
    }

    public ActorFuture<PersistedSnapshot> persist() {
        this.testSnapshotStore.newSnapshot(this);
        this.checksum = this.checksumCalculator.getValue();
        return CompletableActorFuture.completed((Object)this);
    }

    public SnapshotId snapshotId() {
        return new SnapshotId(){

            public long getIndex() {
                return InMemorySnapshot.this.index;
            }

            public long getTerm() {
                return InMemorySnapshot.this.term;
            }

            public long getProcessedPosition() {
                return 0L;
            }

            public long getExportedPosition() {
                return 0L;
            }

            public String getSnapshotIdAsString() {
                return InMemorySnapshot.this.id;
            }
        };
    }

    public int hashCode() {
        return Objects.hash(this.index, this.term, this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InMemorySnapshot that = (InMemorySnapshot)o;
        return this.index == that.index && this.term == that.term && this.id.equals(that.id) && this.chunks.equals(that.chunks);
    }

    public String toString() {
        return "InMemorySnapshot{index=" + this.index + ", term=" + this.term + ", id='" + this.id + "', checksum=" + this.checksum + "}";
    }
}

