/* Generated SBE (Simple Binary Encoding) message codec. */
package io.atomix.raft.storage.serializer;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;
import org.agrona.sbe.*;

@SuppressWarnings("all")
public final class ConfigurationDecoder implements MessageDecoderFlyweight
{
    public static final int BLOCK_LENGTH = 25;
    public static final int TEMPLATE_ID = 5;
    public static final int SCHEMA_ID = 8;
    public static final int SCHEMA_VERSION = 3;
    public static final String SEMANTIC_VERSION = "0.1.0";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final ConfigurationDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public ConfigurationDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public ConfigurationDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public ConfigurationDecoder sbeRewind()
    {
        return wrap(buffer, offset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int actingVersion()
    {
        return actingVersion;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int indexId()
    {
        return 0;
    }

    public static int indexSinceVersion()
    {
        return 0;
    }

    public static int indexEncodingOffset()
    {
        return 0;
    }

    public static int indexEncodingLength()
    {
        return 8;
    }

    public static String indexMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long indexNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long indexMinValue()
    {
        return 0x0L;
    }

    public static long indexMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public long index()
    {
        return buffer.getLong(offset + 0, BYTE_ORDER);
    }


    public static int termId()
    {
        return 1;
    }

    public static int termSinceVersion()
    {
        return 0;
    }

    public static int termEncodingOffset()
    {
        return 8;
    }

    public static int termEncodingLength()
    {
        return 8;
    }

    public static String termMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long termNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long termMinValue()
    {
        return 0x0L;
    }

    public static long termMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public long term()
    {
        return buffer.getLong(offset + 8, BYTE_ORDER);
    }


    public static int timestampId()
    {
        return 2;
    }

    public static int timestampSinceVersion()
    {
        return 0;
    }

    public static int timestampEncodingOffset()
    {
        return 16;
    }

    public static int timestampEncodingLength()
    {
        return 8;
    }

    public static String timestampMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long timestampNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long timestampMinValue()
    {
        return 0x0L;
    }

    public static long timestampMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public long timestamp()
    {
        return buffer.getLong(offset + 16, BYTE_ORDER);
    }


    public static int forceId()
    {
        return 5;
    }

    public static int forceSinceVersion()
    {
        return 3;
    }

    public static int forceEncodingOffset()
    {
        return 24;
    }

    public static int forceEncodingLength()
    {
        return 1;
    }

    public static String forceMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public short forceRaw()
    {
        if (parentMessage.actingVersion < 3)
        {
            return (short)255;
        }

        return ((short)(buffer.getByte(offset + 24) & 0xFF));
    }

    public BooleanType force()
    {
        if (parentMessage.actingVersion < 3)
        {
            return BooleanType.NULL_VAL;
        }

        return BooleanType.get(((short)(buffer.getByte(offset + 24) & 0xFF)));
    }


    private final NewMembersDecoder newMembers = new NewMembersDecoder(this);

    public static long newMembersDecoderId()
    {
        return 3;
    }

    public static int newMembersDecoderSinceVersion()
    {
        return 0;
    }

    public NewMembersDecoder newMembers()
    {
        newMembers.wrap(buffer);
        return newMembers;
    }

    public static final class NewMembersDecoder
        implements Iterable<NewMembersDecoder>, java.util.Iterator<NewMembersDecoder>
    {
        public static final int HEADER_SIZE = 3;
        private final ConfigurationDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        NewMembersDecoder(final ConfigurationDecoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final DirectBuffer buffer)
        {
            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = 0;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + HEADER_SIZE);
            blockLength = (buffer.getShort(limit + 0, BYTE_ORDER) & 0xFFFF);
            count = ((short)(buffer.getByte(limit + 2) & 0xFF));
        }

        public NewMembersDecoder next()
        {
            if (index >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + blockLength);
            ++index;

            return this;
        }

        public static short countMinValue()
        {
            return (short)0;
        }

        public static short countMaxValue()
        {
            return (short)254;
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 9;
        }

        public int actingBlockLength()
        {
            return blockLength;
        }

        public int count()
        {
            return count;
        }

        public java.util.Iterator<NewMembersDecoder> iterator()
        {
            return this;
        }

        public void remove()
        {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext()
        {
            return index < count;
        }

        public static int typeId()
        {
            return 1;
        }

        public static int typeSinceVersion()
        {
            return 0;
        }

        public static int typeEncodingOffset()
        {
            return 0;
        }

        public static int typeEncodingLength()
        {
            return 1;
        }

        public static String typeMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public short typeRaw()
        {
            return ((short)(buffer.getByte(offset + 0) & 0xFF));
        }

        public MemberType type()
        {
            return MemberType.get(((short)(buffer.getByte(offset + 0) & 0xFF)));
        }


        public static int updatedId()
        {
            return 2;
        }

        public static int updatedSinceVersion()
        {
            return 0;
        }

        public static int updatedEncodingOffset()
        {
            return 1;
        }

        public static int updatedEncodingLength()
        {
            return 8;
        }

        public static String updatedMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long updatedNullValue()
        {
            return -9223372036854775808L;
        }

        public static long updatedMinValue()
        {
            return -9223372036854775807L;
        }

        public static long updatedMaxValue()
        {
            return 9223372036854775807L;
        }

        public long updated()
        {
            return buffer.getLong(offset + 1, BYTE_ORDER);
        }


        public static int memberIdId()
        {
            return 3;
        }

        public static int memberIdSinceVersion()
        {
            return 0;
        }

        public static String memberIdCharacterEncoding()
        {
            return java.nio.charset.StandardCharsets.UTF_8.name();
        }

        public static String memberIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int memberIdHeaderLength()
        {
            return 4;
        }

        public int memberIdLength()
        {
            final int limit = parentMessage.limit();
            return (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        }

        public int skipMemberId()
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
            final int dataOffset = limit + headerLength;
            parentMessage.limit(dataOffset + dataLength);

            return dataLength;
        }

        public int getMemberId(final MutableDirectBuffer dst, final int dstOffset, final int length)
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
            final int bytesCopied = Math.min(length, dataLength);
            parentMessage.limit(limit + headerLength + dataLength);
            buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

            return bytesCopied;
        }

        public int getMemberId(final byte[] dst, final int dstOffset, final int length)
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
            final int bytesCopied = Math.min(length, dataLength);
            parentMessage.limit(limit + headerLength + dataLength);
            buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

            return bytesCopied;
        }

        public void wrapMemberId(final DirectBuffer wrapBuffer)
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
            parentMessage.limit(limit + headerLength + dataLength);
            wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
        }

        public String memberId()
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
            parentMessage.limit(limit + headerLength + dataLength);

            if (0 == dataLength)
            {
                return "";
            }

            final byte[] tmp = new byte[dataLength];
            buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

            return new String(tmp, java.nio.charset.StandardCharsets.UTF_8);
        }

        public StringBuilder appendTo(final StringBuilder builder)
        {
            if (null == buffer)
            {
                return builder;
            }

            builder.append('(');
            builder.append("type=");
            builder.append(this.type());
            builder.append('|');
            builder.append("updated=");
            builder.append(this.updated());
            builder.append('|');
            builder.append("memberId=");
            builder.append('\'').append(memberId()).append('\'');
            builder.append(')');

            return builder;
        }
        
        public NewMembersDecoder sbeSkip()
        {
            skipMemberId();

            return this;
        }
    }

    private final OldMembersDecoder oldMembers = new OldMembersDecoder(this);

    public static long oldMembersDecoderId()
    {
        return 4;
    }

    public static int oldMembersDecoderSinceVersion()
    {
        return 2;
    }

    public OldMembersDecoder oldMembers()
    {
        if (parentMessage.actingVersion < 2)
        {
            oldMembers.count = 0;
            oldMembers.index = 0;
            return oldMembers;
        }

        oldMembers.wrap(buffer);
        return oldMembers;
    }

    public static final class OldMembersDecoder
        implements Iterable<OldMembersDecoder>, java.util.Iterator<OldMembersDecoder>
    {
        public static final int HEADER_SIZE = 3;
        private final ConfigurationDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        OldMembersDecoder(final ConfigurationDecoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final DirectBuffer buffer)
        {
            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = 0;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + HEADER_SIZE);
            blockLength = (buffer.getShort(limit + 0, BYTE_ORDER) & 0xFFFF);
            count = ((short)(buffer.getByte(limit + 2) & 0xFF));
        }

        public OldMembersDecoder next()
        {
            if (index >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + blockLength);
            ++index;

            return this;
        }

        public static short countMinValue()
        {
            return (short)0;
        }

        public static short countMaxValue()
        {
            return (short)254;
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 9;
        }

        public int actingBlockLength()
        {
            return blockLength;
        }

        public int count()
        {
            return count;
        }

        public java.util.Iterator<OldMembersDecoder> iterator()
        {
            return this;
        }

        public void remove()
        {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext()
        {
            return index < count;
        }

        public static int typeId()
        {
            return 1;
        }

        public static int typeSinceVersion()
        {
            return 0;
        }

        public static int typeEncodingOffset()
        {
            return 0;
        }

        public static int typeEncodingLength()
        {
            return 1;
        }

        public static String typeMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public short typeRaw()
        {
            return ((short)(buffer.getByte(offset + 0) & 0xFF));
        }

        public MemberType type()
        {
            return MemberType.get(((short)(buffer.getByte(offset + 0) & 0xFF)));
        }


        public static int updatedId()
        {
            return 2;
        }

        public static int updatedSinceVersion()
        {
            return 0;
        }

        public static int updatedEncodingOffset()
        {
            return 1;
        }

        public static int updatedEncodingLength()
        {
            return 8;
        }

        public static String updatedMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long updatedNullValue()
        {
            return -9223372036854775808L;
        }

        public static long updatedMinValue()
        {
            return -9223372036854775807L;
        }

        public static long updatedMaxValue()
        {
            return 9223372036854775807L;
        }

        public long updated()
        {
            return buffer.getLong(offset + 1, BYTE_ORDER);
        }


        public static int memberIdId()
        {
            return 3;
        }

        public static int memberIdSinceVersion()
        {
            return 0;
        }

        public static String memberIdCharacterEncoding()
        {
            return java.nio.charset.StandardCharsets.UTF_8.name();
        }

        public static String memberIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int memberIdHeaderLength()
        {
            return 4;
        }

        public int memberIdLength()
        {
            final int limit = parentMessage.limit();
            return (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        }

        public int skipMemberId()
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
            final int dataOffset = limit + headerLength;
            parentMessage.limit(dataOffset + dataLength);

            return dataLength;
        }

        public int getMemberId(final MutableDirectBuffer dst, final int dstOffset, final int length)
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
            final int bytesCopied = Math.min(length, dataLength);
            parentMessage.limit(limit + headerLength + dataLength);
            buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

            return bytesCopied;
        }

        public int getMemberId(final byte[] dst, final int dstOffset, final int length)
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
            final int bytesCopied = Math.min(length, dataLength);
            parentMessage.limit(limit + headerLength + dataLength);
            buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

            return bytesCopied;
        }

        public void wrapMemberId(final DirectBuffer wrapBuffer)
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
            parentMessage.limit(limit + headerLength + dataLength);
            wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
        }

        public String memberId()
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
            parentMessage.limit(limit + headerLength + dataLength);

            if (0 == dataLength)
            {
                return "";
            }

            final byte[] tmp = new byte[dataLength];
            buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

            return new String(tmp, java.nio.charset.StandardCharsets.UTF_8);
        }

        public StringBuilder appendTo(final StringBuilder builder)
        {
            if (null == buffer)
            {
                return builder;
            }

            builder.append('(');
            builder.append("type=");
            builder.append(this.type());
            builder.append('|');
            builder.append("updated=");
            builder.append(this.updated());
            builder.append('|');
            builder.append("memberId=");
            builder.append('\'').append(memberId()).append('\'');
            builder.append(')');

            return builder;
        }
        
        public OldMembersDecoder sbeSkip()
        {
            skipMemberId();

            return this;
        }
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final ConfigurationDecoder decoder = new ConfigurationDecoder();
        decoder.wrap(buffer, offset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(offset + actingBlockLength);
        builder.append("[Configuration](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("index=");
        builder.append(this.index());
        builder.append('|');
        builder.append("term=");
        builder.append(this.term());
        builder.append('|');
        builder.append("timestamp=");
        builder.append(this.timestamp());
        builder.append('|');
        builder.append("force=");
        builder.append(this.force());
        builder.append('|');
        builder.append("newMembers=[");
        final int newMembersOriginalOffset = newMembers.offset;
        final int newMembersOriginalIndex = newMembers.index;
        final NewMembersDecoder newMembers = this.newMembers();
        if (newMembers.count() > 0)
        {
            while (newMembers.hasNext())
            {
                newMembers.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        newMembers.offset = newMembersOriginalOffset;
        newMembers.index = newMembersOriginalIndex;
        builder.append(']');
        builder.append('|');
        builder.append("oldMembers=[");
        final int oldMembersOriginalOffset = oldMembers.offset;
        final int oldMembersOriginalIndex = oldMembers.index;
        final OldMembersDecoder oldMembers = this.oldMembers();
        if (oldMembers.count() > 0)
        {
            while (oldMembers.hasNext())
            {
                oldMembers.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        oldMembers.offset = oldMembersOriginalOffset;
        oldMembers.index = oldMembersOriginalIndex;
        builder.append(']');

        limit(originalLimit);

        return builder;
    }
    
    public ConfigurationDecoder sbeSkip()
    {
        sbeRewind();
        NewMembersDecoder newMembers = this.newMembers();
        if (newMembers.count() > 0)
        {
            while (newMembers.hasNext())
            {
                newMembers.next();
                newMembers.sbeSkip();
            }
        }
        OldMembersDecoder oldMembers = this.oldMembers();
        if (oldMembers.count() > 0)
        {
            while (oldMembers.hasNext())
            {
                oldMembers.next();
                oldMembers.sbeSkip();
            }
        }

        return this;
    }
}
