/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.serializer;

import io.atomix.raft.storage.serializer.BooleanType;
import io.atomix.raft.storage.serializer.MemberType;
import io.atomix.raft.storage.serializer.MessageHeaderDecoder;
import io.atomix.raft.storage.serializer.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class ConfigurationDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 25;
    public static final int TEMPLATE_ID = 5;
    public static final int SCHEMA_ID = 8;
    public static final int SCHEMA_VERSION = 3;
    public static final String SEMANTIC_VERSION = "0.1.0";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ConfigurationDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final NewMembersDecoder newMembers = new NewMembersDecoder(this);
    private final OldMembersDecoder oldMembers = new OldMembersDecoder(this);

    public int sbeBlockLength() {
        return 25;
    }

    public int sbeTemplateId() {
        return 5;
    }

    public int sbeSchemaId() {
        return 8;
    }

    public int sbeSchemaVersion() {
        return 3;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ConfigurationDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public ConfigurationDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (5 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public ConfigurationDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int indexId() {
        return 0;
    }

    public static int indexSinceVersion() {
        return 0;
    }

    public static int indexEncodingOffset() {
        return 0;
    }

    public static int indexEncodingLength() {
        return 8;
    }

    public static String indexMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long indexNullValue() {
        return -1L;
    }

    public static long indexMinValue() {
        return 0L;
    }

    public static long indexMaxValue() {
        return -2L;
    }

    public long index() {
        return this.buffer.getLong(this.offset + 0, BYTE_ORDER);
    }

    public static int termId() {
        return 1;
    }

    public static int termSinceVersion() {
        return 0;
    }

    public static int termEncodingOffset() {
        return 8;
    }

    public static int termEncodingLength() {
        return 8;
    }

    public static String termMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long termNullValue() {
        return -1L;
    }

    public static long termMinValue() {
        return 0L;
    }

    public static long termMaxValue() {
        return -2L;
    }

    public long term() {
        return this.buffer.getLong(this.offset + 8, BYTE_ORDER);
    }

    public static int timestampId() {
        return 2;
    }

    public static int timestampSinceVersion() {
        return 0;
    }

    public static int timestampEncodingOffset() {
        return 16;
    }

    public static int timestampEncodingLength() {
        return 8;
    }

    public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long timestampNullValue() {
        return -1L;
    }

    public static long timestampMinValue() {
        return 0L;
    }

    public static long timestampMaxValue() {
        return -2L;
    }

    public long timestamp() {
        return this.buffer.getLong(this.offset + 16, BYTE_ORDER);
    }

    public static int forceId() {
        return 5;
    }

    public static int forceSinceVersion() {
        return 3;
    }

    public static int forceEncodingOffset() {
        return 24;
    }

    public static int forceEncodingLength() {
        return 1;
    }

    public static String forceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short forceRaw() {
        if (this.parentMessage.actingVersion < 3) {
            return 255;
        }
        return (short)(this.buffer.getByte(this.offset + 24) & 0xFF);
    }

    public BooleanType force() {
        if (this.parentMessage.actingVersion < 3) {
            return BooleanType.NULL_VAL;
        }
        return BooleanType.get((short)(this.buffer.getByte(this.offset + 24) & 0xFF));
    }

    public static long newMembersDecoderId() {
        return 3L;
    }

    public static int newMembersDecoderSinceVersion() {
        return 0;
    }

    public NewMembersDecoder newMembers() {
        this.newMembers.wrap(this.buffer);
        return this.newMembers;
    }

    public static long oldMembersDecoderId() {
        return 4L;
    }

    public static int oldMembersDecoderSinceVersion() {
        return 2;
    }

    public OldMembersDecoder oldMembers() {
        if (this.parentMessage.actingVersion < 2) {
            this.oldMembers.count = 0;
            this.oldMembers.index = 0;
            return this.oldMembers;
        }
        this.oldMembers.wrap(this.buffer);
        return this.oldMembers;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ConfigurationDecoder decoder = new ConfigurationDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[Configuration](sbeTemplateId=");
        builder.append(5);
        builder.append("|sbeSchemaId=");
        builder.append(8);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 3) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(3);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 25) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(25);
        builder.append("):");
        builder.append("index=");
        builder.append(this.index());
        builder.append('|');
        builder.append("term=");
        builder.append(this.term());
        builder.append('|');
        builder.append("timestamp=");
        builder.append(this.timestamp());
        builder.append('|');
        builder.append("force=");
        builder.append((Object)this.force());
        builder.append('|');
        builder.append("newMembers=[");
        int newMembersOriginalOffset = this.newMembers.offset;
        int newMembersOriginalIndex = this.newMembers.index;
        NewMembersDecoder newMembers = this.newMembers();
        if (newMembers.count() > 0) {
            while (newMembers.hasNext()) {
                newMembers.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        newMembers.offset = newMembersOriginalOffset;
        newMembers.index = newMembersOriginalIndex;
        builder.append(']');
        builder.append('|');
        builder.append("oldMembers=[");
        int oldMembersOriginalOffset = this.oldMembers.offset;
        int oldMembersOriginalIndex = this.oldMembers.index;
        OldMembersDecoder oldMembers = this.oldMembers();
        if (oldMembers.count() > 0) {
            while (oldMembers.hasNext()) {
                oldMembers.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        oldMembers.offset = oldMembersOriginalOffset;
        oldMembers.index = oldMembersOriginalIndex;
        builder.append(']');
        this.limit(originalLimit);
        return builder;
    }

    public ConfigurationDecoder sbeSkip() {
        OldMembersDecoder oldMembers;
        this.sbeRewind();
        NewMembersDecoder newMembers = this.newMembers();
        if (newMembers.count() > 0) {
            while (newMembers.hasNext()) {
                newMembers.next();
                newMembers.sbeSkip();
            }
        }
        if ((oldMembers = this.oldMembers()).count() > 0) {
            while (oldMembers.hasNext()) {
                oldMembers.next();
                oldMembers.sbeSkip();
            }
        }
        return this;
    }

    public static final class NewMembersDecoder
    implements Iterable<NewMembersDecoder>,
    Iterator<NewMembersDecoder> {
        public static final int HEADER_SIZE = 3;
        private final ConfigurationDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        NewMembersDecoder(ConfigurationDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, BYTE_ORDER) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public NewMembersDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 9;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<NewMembersDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int typeId() {
            return 1;
        }

        public static int typeSinceVersion() {
            return 0;
        }

        public static int typeEncodingOffset() {
            return 0;
        }

        public static int typeEncodingLength() {
            return 1;
        }

        public static String typeMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public short typeRaw() {
            return (short)(this.buffer.getByte(this.offset + 0) & 0xFF);
        }

        public MemberType type() {
            return MemberType.get((short)(this.buffer.getByte(this.offset + 0) & 0xFF));
        }

        public static int updatedId() {
            return 2;
        }

        public static int updatedSinceVersion() {
            return 0;
        }

        public static int updatedEncodingOffset() {
            return 1;
        }

        public static int updatedEncodingLength() {
            return 8;
        }

        public static String updatedMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long updatedNullValue() {
            return Long.MIN_VALUE;
        }

        public static long updatedMinValue() {
            return -9223372036854775807L;
        }

        public static long updatedMaxValue() {
            return Long.MAX_VALUE;
        }

        public long updated() {
            return this.buffer.getLong(this.offset + 1, BYTE_ORDER);
        }

        public static int memberIdId() {
            return 3;
        }

        public static int memberIdSinceVersion() {
            return 0;
        }

        public static String memberIdCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String memberIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int memberIdHeaderLength() {
            return 4;
        }

        public int memberIdLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        }

        public int skipMemberId() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getMemberId(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getMemberId(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapMemberId(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String memberId() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            return new String(tmp, StandardCharsets.UTF_8);
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("type=");
            builder.append((Object)this.type());
            builder.append('|');
            builder.append("updated=");
            builder.append(this.updated());
            builder.append('|');
            builder.append("memberId=");
            builder.append('\'').append(this.memberId()).append('\'');
            builder.append(')');
            return builder;
        }

        public NewMembersDecoder sbeSkip() {
            this.skipMemberId();
            return this;
        }
    }

    public static final class OldMembersDecoder
    implements Iterable<OldMembersDecoder>,
    Iterator<OldMembersDecoder> {
        public static final int HEADER_SIZE = 3;
        private final ConfigurationDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        OldMembersDecoder(ConfigurationDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, BYTE_ORDER) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public OldMembersDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 9;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<OldMembersDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int typeId() {
            return 1;
        }

        public static int typeSinceVersion() {
            return 0;
        }

        public static int typeEncodingOffset() {
            return 0;
        }

        public static int typeEncodingLength() {
            return 1;
        }

        public static String typeMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public short typeRaw() {
            return (short)(this.buffer.getByte(this.offset + 0) & 0xFF);
        }

        public MemberType type() {
            return MemberType.get((short)(this.buffer.getByte(this.offset + 0) & 0xFF));
        }

        public static int updatedId() {
            return 2;
        }

        public static int updatedSinceVersion() {
            return 0;
        }

        public static int updatedEncodingOffset() {
            return 1;
        }

        public static int updatedEncodingLength() {
            return 8;
        }

        public static String updatedMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long updatedNullValue() {
            return Long.MIN_VALUE;
        }

        public static long updatedMinValue() {
            return -9223372036854775807L;
        }

        public static long updatedMaxValue() {
            return Long.MAX_VALUE;
        }

        public long updated() {
            return this.buffer.getLong(this.offset + 1, BYTE_ORDER);
        }

        public static int memberIdId() {
            return 3;
        }

        public static int memberIdSinceVersion() {
            return 0;
        }

        public static String memberIdCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String memberIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int memberIdHeaderLength() {
            return 4;
        }

        public int memberIdLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        }

        public int skipMemberId() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getMemberId(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getMemberId(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapMemberId(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String memberId() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            return new String(tmp, StandardCharsets.UTF_8);
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("type=");
            builder.append((Object)this.type());
            builder.append('|');
            builder.append("updated=");
            builder.append(this.updated());
            builder.append('|');
            builder.append("memberId=");
            builder.append('\'').append(this.memberId()).append('\'');
            builder.append(')');
            return builder;
        }

        public OldMembersDecoder sbeSkip() {
            this.skipMemberId();
            return this;
        }
    }
}

