/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.partition;

import io.atomix.raft.partition.RaftStorageConfig;
import io.atomix.raft.zeebe.EntryValidator;
import java.time.Duration;

public class RaftPartitionConfig {
    private static final Duration DEFAULT_ELECTION_TIMEOUT = Duration.ofMillis(2500L);
    private static final Duration DEFAULT_SNAPSHOT_REQUEST_TIMEOUT = Duration.ofMillis(2500L);
    private static final Duration DEFAULT_HEARTBEAT_INTERVAL = Duration.ofMillis(250L);
    private static final boolean DEFAULT_PRIORITY_ELECTION = true;
    private static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(5L);
    private static final int DEFAULT_MIN_STEP_DOWN_FAILURE_COUNT = 3;
    private static final Duration DEFAULT_MAX_QUORUM_RESPONSE_TIMEOUT = Duration.ofSeconds(0L);
    private static final int DEFAULT_SNAPSHOT_REPLICATION_THRESHOLD = 100;
    private Duration electionTimeout = DEFAULT_ELECTION_TIMEOUT;
    private Duration heartbeatInterval = DEFAULT_HEARTBEAT_INTERVAL;
    private int maxAppendsPerFollower = 2;
    private int maxAppendBatchSize = 32768;
    private boolean priorityElectionEnabled = true;
    private Duration requestTimeout = DEFAULT_REQUEST_TIMEOUT;
    private Duration snapshotRequestTimeout = DEFAULT_SNAPSHOT_REQUEST_TIMEOUT;
    private int minStepDownFailureCount = 3;
    private Duration maxQuorumResponseTimeout = DEFAULT_MAX_QUORUM_RESPONSE_TIMEOUT;
    private int preferSnapshotReplicationThreshold = 100;
    private RaftStorageConfig storageConfig;
    private EntryValidator entryValidator;
    private Duration configurationChangeTimeout;

    public Duration getElectionTimeout() {
        return this.electionTimeout;
    }

    public RaftPartitionConfig setElectionTimeout(Duration electionTimeout) {
        this.electionTimeout = electionTimeout;
        return this;
    }

    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public RaftPartitionConfig setHeartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
        return this;
    }

    public int getMaxAppendsPerFollower() {
        return this.maxAppendsPerFollower;
    }

    public void setMaxAppendsPerFollower(int maxAppendsPerFollower) {
        this.maxAppendsPerFollower = maxAppendsPerFollower;
    }

    public int getMaxAppendBatchSize() {
        return this.maxAppendBatchSize;
    }

    public void setMaxAppendBatchSize(int maxAppendBatchSize) {
        this.maxAppendBatchSize = maxAppendBatchSize;
    }

    public boolean isPriorityElectionEnabled() {
        return this.priorityElectionEnabled;
    }

    public void setPriorityElectionEnabled(boolean enable) {
        this.priorityElectionEnabled = enable;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public Duration getSnapshotRequestTimeout() {
        return this.snapshotRequestTimeout;
    }

    public void setSnapshotRequestTimeout(Duration snapshotRequestTimeout) {
        this.snapshotRequestTimeout = snapshotRequestTimeout;
    }

    public Duration getConfigurationChangeTimeout() {
        return this.configurationChangeTimeout;
    }

    public void setConfigurationChangeTimeout(Duration configurationChangeTimeout) {
        this.configurationChangeTimeout = configurationChangeTimeout;
    }

    public int getMinStepDownFailureCount() {
        return this.minStepDownFailureCount;
    }

    public void setMinStepDownFailureCount(int minStepDownFailureCount) {
        this.minStepDownFailureCount = minStepDownFailureCount;
    }

    public Duration getMaxQuorumResponseTimeout() {
        return this.maxQuorumResponseTimeout;
    }

    public void setMaxQuorumResponseTimeout(Duration maxQuorumResponseTimeout) {
        this.maxQuorumResponseTimeout = maxQuorumResponseTimeout;
    }

    public int getPreferSnapshotReplicationThreshold() {
        return this.preferSnapshotReplicationThreshold;
    }

    public void setPreferSnapshotReplicationThreshold(int preferSnapshotReplicationThreshold) {
        this.preferSnapshotReplicationThreshold = preferSnapshotReplicationThreshold;
    }

    public RaftStorageConfig getStorageConfig() {
        return this.storageConfig;
    }

    public void setStorageConfig(RaftStorageConfig storageConfig) {
        this.storageConfig = storageConfig;
    }

    public EntryValidator getEntryValidator() {
        return this.entryValidator;
    }

    public void setEntryValidator(EntryValidator entryValidator) {
        this.entryValidator = entryValidator;
    }

    public String toString() {
        return "RaftPartitionConfig{electionTimeout=" + String.valueOf(this.electionTimeout) + ", heartbeatInterval=" + String.valueOf(this.heartbeatInterval) + ", maxAppendsPerFollower=" + this.maxAppendsPerFollower + ", maxAppendBatchSize=" + this.maxAppendBatchSize + ", priorityElectionEnabled=" + this.priorityElectionEnabled + ", requestTimeout=" + String.valueOf(this.requestTimeout) + ", snapshotRequestTimeout=" + String.valueOf(this.snapshotRequestTimeout) + ", configurationChangeTimeout=" + String.valueOf(this.configurationChangeTimeout) + ", minStepDownFailureCount=" + this.minStepDownFailureCount + ", maxQuorumResponseTimeout=" + String.valueOf(this.maxQuorumResponseTimeout) + ", preferSnapshotReplicationThreshold=" + this.preferSnapshotReplicationThreshold + "}";
    }
}

