/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.roles;

import io.atomix.cluster.ClusterMembershipService;
import io.atomix.raft.RaftException;
import io.atomix.raft.RaftServer;
import io.atomix.raft.impl.LogCompactor;
import io.atomix.raft.impl.RaftContext;
import io.atomix.raft.metrics.RaftReplicationMetrics;
import io.atomix.raft.protocol.PersistedRaftRecord;
import io.atomix.raft.protocol.ReplicatableJournalRecord;
import io.atomix.raft.roles.LeaderRole;
import io.atomix.raft.storage.RaftStorage;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.raft.storage.log.entry.ApplicationEntry;
import io.atomix.raft.storage.log.entry.RaftEntry;
import io.atomix.raft.storage.log.entry.RaftLogEntry;
import io.atomix.raft.zeebe.EntryValidator;
import io.atomix.raft.zeebe.ZeebeLogAppender;
import io.atomix.raft.zeebe.util.TestAppender;
import io.atomix.utils.concurrent.SingleThreadContext;
import io.camunda.zeebe.journal.JournalException;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class LeaderRoleTest {
    private LeaderRole leaderRole;
    private RaftContext context;
    private RaftLog log;
    private LogCompactor logCompactor;

    @Before
    public void setup() {
        this.context = (RaftContext)Mockito.mock(RaftContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.logCompactor = (LogCompactor)Mockito.mock(LogCompactor.class);
        Mockito.when((Object)this.context.getName()).thenReturn((Object)"leader");
        Mockito.when((Object)this.context.getElectionTimeout()).thenReturn((Object)Duration.ofMillis(100L));
        Mockito.when((Object)this.context.getHeartbeatInterval()).thenReturn((Object)Duration.ofMillis(100L));
        Mockito.when((Object)this.context.getReplicationMetrics()).thenReturn((Object)((RaftReplicationMetrics)Mockito.mock(RaftReplicationMetrics.class)));
        Mockito.when((Object)this.context.getLogCompactor()).thenReturn((Object)this.logCompactor);
        SingleThreadContext threadContext = new SingleThreadContext("leader");
        Mockito.when((Object)this.context.getThreadContext()).thenReturn((Object)threadContext);
        this.log = (RaftLog)Mockito.mock(RaftLog.class);
        Mockito.when((Object)this.log.getLastIndex()).thenReturn((Object)1L);
        Mockito.when((Object)this.log.append((RaftLogEntry)ArgumentMatchers.any(RaftLogEntry.class))).then(i -> {
            RaftLogEntry raftEntry = (RaftLogEntry)i.getArgument(0);
            return new TestIndexedRaftLogEntry(1L, 1L, (RaftEntry)raftEntry.getApplicationEntry());
        });
        Mockito.when((Object)this.context.getLog()).thenReturn((Object)this.log);
        ReceivableSnapshotStore persistedSnapshotStore = (ReceivableSnapshotStore)Mockito.mock(ReceivableSnapshotStore.class);
        Mockito.when((Object)this.context.getPersistedSnapshotStore()).thenReturn((Object)persistedSnapshotStore);
        Mockito.when((Object)this.context.getEntryValidator()).thenReturn((a, b) -> EntryValidator.ValidationResult.ok());
        Mockito.when((Object)this.context.getStorage()).thenReturn((Object)RaftStorage.builder().withMaxSegmentSize(1024).build());
        this.leaderRole = new LeaderRole(this.context);
        ((RaftContext)Mockito.doAnswer(i -> this.leaderRole.stop().join()).when((Object)this.context)).transition(RaftServer.Role.FOLLOWER);
        Mockito.when((Object)this.context.getMembershipService()).thenReturn((Object)((ClusterMembershipService)Mockito.mock(ClusterMembershipService.class)));
    }

    @Test
    public void shouldAppendEntry() throws InterruptedException {
        ByteBuffer data = ByteBuffer.allocate(4).putInt(0, 1);
        final CountDownLatch latch = new CountDownLatch(1);
        ZeebeLogAppender.AppendListener listener = new ZeebeLogAppender.AppendListener(){

            public void onWrite(IndexedRaftLogEntry indexed) {
                latch.countDown();
            }
        };
        this.leaderRole.appendEntry(0L, 1L, data, listener);
        Assertions.assertThat((boolean)latch.await(10L, TimeUnit.SECONDS)).isTrue();
        Assertions.assertThat((long)latch.getCount()).isZero();
    }

    @Test
    public void shouldRetryAppendEntryOnIOException() throws InterruptedException {
        Mockito.when((Object)this.log.append((RaftLogEntry)ArgumentMatchers.any(RaftLogEntry.class))).thenThrow(new Throwable[]{new JournalException((Throwable)new IOException())}).thenThrow(new Throwable[]{new JournalException((Throwable)new IOException())}).then(i -> {
            RaftLogEntry raftLogEntry = (RaftLogEntry)i.getArgument(0);
            return new TestIndexedRaftLogEntry(1L, 1L, (RaftEntry)raftLogEntry.getApplicationEntry());
        });
        ByteBuffer data = ByteBuffer.allocate(4).putInt(0, 1);
        final CountDownLatch latch = new CountDownLatch(1);
        ZeebeLogAppender.AppendListener listener = new ZeebeLogAppender.AppendListener(){

            public void onWrite(IndexedRaftLogEntry indexed) {
                latch.countDown();
            }
        };
        this.leaderRole.appendEntry(0L, 1L, data, listener);
        Assertions.assertThat((boolean)latch.await(10L, TimeUnit.SECONDS)).isTrue();
        ((RaftLog)Mockito.verify((Object)this.log, (VerificationMode)Mockito.timeout((long)1000L).atLeast(3))).append((RaftLogEntry)ArgumentMatchers.any(RaftLogEntry.class));
    }

    @Test
    public void shouldStopRetryAppendEntryAfterMaxRetries() throws InterruptedException {
        Mockito.when((Object)this.log.append((RaftLogEntry)ArgumentMatchers.any(RaftLogEntry.class))).thenThrow(new Throwable[]{new JournalException((Throwable)new IOException())});
        final AtomicReference caughtError = new AtomicReference();
        ByteBuffer data = ByteBuffer.allocate(4).putInt(0, 1);
        final CountDownLatch latch = new CountDownLatch(1);
        ZeebeLogAppender.AppendListener listener = new ZeebeLogAppender.AppendListener(){

            public void onWriteError(Throwable error) {
                caughtError.set(error);
                latch.countDown();
            }
        };
        this.leaderRole.appendEntry(0L, 1L, data, listener);
        Assertions.assertThat((boolean)latch.await(10L, TimeUnit.SECONDS)).isTrue();
        ((RaftLog)Mockito.verify((Object)this.log, (VerificationMode)Mockito.timeout((long)1000L).atLeast(5))).append((RaftLogEntry)ArgumentMatchers.any(RaftLogEntry.class));
        ((RaftContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.timeout((long)1000L))).transition(RaftServer.Role.FOLLOWER);
        Assertions.assertThat((Throwable)((Throwable)caughtError.get())).isInstanceOf(IOException.class);
    }

    @Test
    public void shouldCompactOnOutOfDiskSpace() throws InterruptedException {
        Mockito.when((Object)this.log.append((RaftLogEntry)ArgumentMatchers.any(RaftLogEntry.class))).thenThrow(new Throwable[]{new JournalException.OutOfDiskSpace("Boom file out")}).then(i -> {
            RaftLogEntry raftLogEntry = (RaftLogEntry)i.getArgument(0);
            return new TestIndexedRaftLogEntry(1L, 1L, (RaftEntry)raftLogEntry.getApplicationEntry());
        });
        Mockito.when((Object)this.context.getLogCompactor().compactIgnoringReplicationThreshold()).thenReturn((Object)true);
        ByteBuffer data = ByteBuffer.allocate(4).putInt(0, 1);
        final CountDownLatch latch = new CountDownLatch(1);
        ZeebeLogAppender.AppendListener listener = new ZeebeLogAppender.AppendListener(){

            public void onWrite(IndexedRaftLogEntry indexed) {
                latch.countDown();
            }
        };
        this.leaderRole.appendEntry(0L, 1L, data, listener);
        Assertions.assertThat((boolean)latch.await(10L, TimeUnit.SECONDS)).isTrue();
        ((LogCompactor)Mockito.verify((Object)this.logCompactor, (VerificationMode)Mockito.times((int)1))).compactIgnoringReplicationThreshold();
    }

    @Test
    public void shouldStopAppendEntryOnOutOfDisk() throws InterruptedException {
        Mockito.when((Object)this.log.append((RaftLogEntry)ArgumentMatchers.any(RaftLogEntry.class))).thenThrow(new Throwable[]{new JournalException.OutOfDiskSpace("Boom file out")}).then(i -> {
            RaftLogEntry raftLogEntry = (RaftLogEntry)i.getArgument(0);
            return new TestIndexedRaftLogEntry(1L, 1L, (RaftEntry)raftLogEntry.getApplicationEntry());
        });
        Mockito.when((Object)this.context.getLogCompactor().compactIgnoringReplicationThreshold()).thenReturn((Object)false);
        final AtomicReference caughtError = new AtomicReference();
        ByteBuffer data = ByteBuffer.allocate(4).putInt(0, 1);
        final CountDownLatch latch = new CountDownLatch(1);
        ZeebeLogAppender.AppendListener listener = new ZeebeLogAppender.AppendListener(){

            public void onWriteError(Throwable error) {
                caughtError.set(error);
                latch.countDown();
            }
        };
        this.leaderRole.appendEntry(0L, 1L, data, listener);
        Assertions.assertThat((boolean)latch.await(10L, TimeUnit.SECONDS)).isTrue();
        Assertions.assertThat((Throwable)((Throwable)caughtError.get())).isInstanceOf(JournalException.OutOfDiskSpace.class);
        ((LogCompactor)Mockito.verify((Object)this.logCompactor, (VerificationMode)Mockito.times((int)1))).compactIgnoringReplicationThreshold();
        ((RaftContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.timeout((long)1000L))).transition(RaftServer.Role.FOLLOWER);
        ((RaftLog)Mockito.verify((Object)this.log, (VerificationMode)Mockito.timeout((long)1000L))).append((RaftLogEntry)ArgumentMatchers.any(RaftLogEntry.class));
    }

    @Test
    public void shouldTransitionToFollowerWhenAppendEntryException() throws InterruptedException {
        Mockito.when((Object)this.log.append((RaftLogEntry)ArgumentMatchers.any(RaftLogEntry.class))).thenThrow(new Throwable[]{new RuntimeException("expected")});
        final AtomicReference caughtError = new AtomicReference();
        ByteBuffer data = ByteBuffer.allocate(4).putInt(0, 1);
        final CountDownLatch latch = new CountDownLatch(1);
        ZeebeLogAppender.AppendListener listener = new ZeebeLogAppender.AppendListener(){

            public void onWriteError(Throwable error) {
                caughtError.set(error);
                latch.countDown();
            }
        };
        this.leaderRole.appendEntry(2L, 3L, data, listener);
        Assertions.assertThat((boolean)latch.await(10L, TimeUnit.SECONDS)).isTrue();
        ((RaftLog)Mockito.verify((Object)this.log, (VerificationMode)Mockito.timeout((long)1000L))).append((RaftLogEntry)ArgumentMatchers.any(RaftLogEntry.class));
        ((RaftContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.timeout((long)1000L))).transition(RaftServer.Role.FOLLOWER);
        Assertions.assertThat((Throwable)((Throwable)caughtError.get())).isInstanceOf(RuntimeException.class);
    }

    @Test
    public void shouldNotAppendFollowingEntryOnException() throws InterruptedException {
        Mockito.when((Object)this.log.append((RaftLogEntry)ArgumentMatchers.any(RaftLogEntry.class))).thenThrow(new Throwable[]{new RuntimeException("expected")});
        final AtomicReference caughtError = new AtomicReference();
        ByteBuffer data = ByteBuffer.allocate(4).putInt(0, 1);
        final CountDownLatch latch = new CountDownLatch(1);
        this.leaderRole.appendEntry(0L, 1L, data, new ZeebeLogAppender.AppendListener(this){});
        this.leaderRole.appendEntry(2L, 3L, data, new ZeebeLogAppender.AppendListener(){

            public void onWriteError(Throwable error) {
                caughtError.set(error);
                latch.countDown();
            }
        });
        Assertions.assertThat((boolean)latch.await(10L, TimeUnit.SECONDS)).isTrue();
        ((RaftContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.timeout((long)1000L))).transition(RaftServer.Role.FOLLOWER);
        ((RaftLog)Mockito.verify((Object)this.log, (VerificationMode)Mockito.timeout((long)1000L))).append((RaftLogEntry)ArgumentMatchers.any(RaftLogEntry.class));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)((Throwable)caughtError.get())).isInstanceOf(RaftException.NoLeader.class)).hasMessage("LeaderRole is closed and cannot be used as appender");
    }

    @Test
    public void shouldRetryAppendEntriesInOrder() throws InterruptedException {
        Mockito.when((Object)this.log.append((RaftLogEntry)ArgumentMatchers.any(RaftLogEntry.class))).thenThrow(new Throwable[]{new JournalException((Throwable)new IOException())}).thenThrow(new Throwable[]{new JournalException((Throwable)new IOException())}).then(i -> {
            RaftLogEntry raftEntry = (RaftLogEntry)i.getArgument(0);
            return new TestIndexedRaftLogEntry(1L, 1L, (RaftEntry)raftEntry.getApplicationEntry());
        });
        ByteBuffer data = ByteBuffer.allocate(4).putInt(0, 1);
        final CopyOnWriteArrayList entries = new CopyOnWriteArrayList();
        final CountDownLatch latch = new CountDownLatch(2);
        ZeebeLogAppender.AppendListener listener = new ZeebeLogAppender.AppendListener(){

            public void onWrite(IndexedRaftLogEntry indexed) {
                entries.add(indexed.getApplicationEntry());
                latch.countDown();
            }
        };
        this.leaderRole.appendEntry(0L, 1L, data, listener);
        this.leaderRole.appendEntry(1L, 2L, data, listener);
        Assertions.assertThat((boolean)latch.await(10L, TimeUnit.SECONDS)).isTrue();
        ((RaftLog)Mockito.verify((Object)this.log, (VerificationMode)Mockito.timeout((long)1000L).atLeast(3))).append((RaftLogEntry)ArgumentMatchers.any(RaftLogEntry.class));
        Assertions.assertThat(entries).hasSize(2);
        Assertions.assertThat((long)((ApplicationEntry)entries.get(0)).highestPosition()).isOne();
        Assertions.assertThat((long)((ApplicationEntry)entries.get(1)).highestPosition()).isEqualTo(2L);
    }

    @Test
    public void shouldDetectInconsistencyWithLastEntry() throws InterruptedException {
        Mockito.when((Object)this.log.append((RaftLogEntry)ArgumentMatchers.any(RaftLogEntry.class))).then(i -> {
            RaftLogEntry raftLogEntry = (RaftLogEntry)i.getArgument(0);
            return new TestIndexedRaftLogEntry(1L, 1L, (RaftEntry)raftLogEntry.getApplicationEntry());
        });
        ByteBuffer data = ByteBuffer.allocate(4).putInt(0, 1);
        final CountDownLatch latch = new CountDownLatch(2);
        Mockito.when((Object)this.context.getEntryValidator()).thenReturn((lastEntry, entry) -> {
            if (lastEntry != null) {
                Assertions.assertThat((long)lastEntry.highestPosition()).isEqualTo(7L);
                Assertions.assertThat((long)entry.lowestPosition()).isEqualTo(9L);
                Assertions.assertThat((long)entry.highestPosition()).isEqualTo(9L);
                latch.countDown();
                return EntryValidator.ValidationResult.failure((String)"expected");
            }
            return EntryValidator.ValidationResult.ok();
        });
        this.leaderRole = new LeaderRole(this.context);
        ZeebeLogAppender.AppendListener listener = new ZeebeLogAppender.AppendListener(){

            public void onWriteError(Throwable error) {
                latch.countDown();
            }
        };
        this.leaderRole.appendEntry(6L, 7L, data, (ZeebeLogAppender.AppendListener)new TestAppender());
        this.leaderRole.appendEntry(9L, 9L, data, listener);
        Assertions.assertThat((boolean)latch.await(5L, TimeUnit.SECONDS)).isTrue();
        ((RaftContext)Mockito.verify((Object)this.leaderRole.raft, (VerificationMode)Mockito.timeout((long)2000L).atLeast(1))).transition(RaftServer.Role.FOLLOWER);
    }

    private record TestIndexedRaftLogEntry(long index, long term, RaftEntry entry) implements IndexedRaftLogEntry
    {
        public boolean isApplicationEntry() {
            return true;
        }

        public ApplicationEntry getApplicationEntry() {
            return (ApplicationEntry)this.entry;
        }

        public PersistedRaftRecord getPersistedRaftRecord() {
            return null;
        }

        public ReplicatableJournalRecord getReplicatableJournalRecord() {
            return null;
        }
    }
}

