/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.raft.RaftRule;
import io.atomix.raft.RaftServer;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RaftReplicationTest {
    @Rule
    @Parameterized.Parameter
    public RaftRule raftRule;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Object[][] raftConfigurations() {
        return new Object[][]{{RaftRule.withBootstrappedNodes(3)}, {RaftRule.withBootstrappedNodes(4)}, {RaftRule.withBootstrappedNodes(5)}};
    }

    @Test
    public void shouldPreferReplicatingEvents() throws Exception {
        int entryCount = 10;
        int snapshotIndex = 15;
        RaftServer leader = this.raftRule.getLeader().orElseThrow();
        RaftServer follower = this.raftRule.getFollower().orElseThrow();
        this.raftRule.appendEntries(10);
        this.raftRule.partition(follower);
        long lastCommitIndex = this.raftRule.appendEntries(10);
        this.raftRule.takeSnapshot(leader, 15L, 1);
        this.raftRule.reconnect(follower);
        Assertions.assertThat((long)follower.getContext().getPersistedSnapshotStore().getCurrentSnapshotIndex()).isNotEqualTo(15L);
        this.raftRule.awaitSameLogSizeOnAllNodes(lastCommitIndex);
    }

    @Test
    public void shouldReplicateSnapshotIfEventsNotAvailable() throws Exception {
        RaftServer leader = this.raftRule.getLeader().orElseThrow();
        RaftServer follower = this.raftRule.getFollower().orElseThrow();
        this.raftRule.appendEntries(50);
        this.raftRule.partition(follower);
        long lastCommitIndex = this.raftRule.appendEntries(200);
        this.raftRule.takeCompactingSnapshot(leader, 200L, 3);
        this.raftRule.reconnect(follower);
        this.raftRule.awaitSameLogSizeOnAllNodes(lastCommitIndex);
        Assertions.assertThat((long)follower.getContext().getPersistedSnapshotStore().getCurrentSnapshotIndex()).isEqualTo(200L);
    }

    @Test
    public void shouldReplicateSnapshotIfMemberLagAboveThreshold() throws Exception {
        int entryCount = 10;
        int snapshotIndex = 15;
        RaftServer leader = this.raftRule.getLeader().orElseThrow();
        RaftServer follower = this.raftRule.getFollower().orElseThrow();
        this.raftRule.appendEntries(10);
        this.raftRule.partition(follower);
        long lastCommitIndex = this.raftRule.appendEntries(10);
        leader.getContext().setPreferSnapshotReplicationThreshold(1);
        this.raftRule.takeSnapshot(leader, 15L, 1);
        this.raftRule.reconnect(follower);
        this.raftRule.awaitSameLogSizeOnAllNodes(lastCommitIndex);
        Assertions.assertThat((long)this.raftRule.getLeader().orElseThrow().getContext().getLog().getFirstIndex()).isLessThan(15L);
        Assertions.assertThat((long)follower.getContext().getPersistedSnapshotStore().getCurrentSnapshotIndex()).isEqualTo(15L);
    }

    @Test
    public void shouldNotGetStuckInSnapshotReplicationLoop() throws Exception {
        RaftServer initialLeader = this.raftRule.getLeader().orElseThrow();
        long snapshotIndex = this.raftRule.appendEntries(5);
        this.raftRule.takeSnapshot(initialLeader, snapshotIndex, 3);
        this.raftRule.appendEntries(5);
        this.raftRule.getServers().stream().filter(s -> s.getRole() == RaftServer.Role.FOLLOWER).toList().forEach(follower -> {
            try {
                this.raftRule.shutdownServer((RaftServer)follower);
                this.raftRule.triggerDataLossOnNode(follower.name());
                this.raftRule.joinCluster(follower.name());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.raftRule.shutdownServer(initialLeader);
        this.raftRule.awaitNewLeader();
        this.raftRule.triggerDataLossOnNode(initialLeader.name());
        this.raftRule.joinCluster(initialLeader.name());
        this.raftRule.allNodesHaveSnapshotWithIndex(snapshotIndex);
        Awaitility.await((String)"All members should have the latest log").until(() -> this.raftRule.getServers().stream().map(s -> s.getContext().getLog().getLastIndex()).collect(Collectors.toSet()).size() == 1);
    }
}

