/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.zeebe;

import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.entry.ApplicationEntry;
import io.atomix.raft.storage.log.entry.SerializedApplicationEntry;
import io.atomix.raft.storage.log.entry.UnserializedApplicationEntry;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.nio.ByteBuffer;

@FunctionalInterface
public interface ZeebeLogAppender {
    public void appendEntry(ApplicationEntry var1, AppendListener var2);

    default public void appendEntry(long lowestPosition, long highestPosition, ByteBuffer data, AppendListener appendListener) {
        this.appendEntry(new SerializedApplicationEntry(lowestPosition, highestPosition, data), appendListener);
    }

    default public void appendEntry(long lowestPosition, long highestPosition, BufferWriter data, AppendListener appendListener) {
        this.appendEntry(new UnserializedApplicationEntry(lowestPosition, highestPosition, data), appendListener);
    }

    public static interface AppendListener {
        default public void onWrite(IndexedRaftLogEntry indexed) {
        }

        default public void onWriteError(Throwable error) {
        }

        default public void onCommit(long index) {
        }

        default public void onCommitError(long index, Throwable error) {
        }
    }
}

