/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.system;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.atomix.cluster.MemberId;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record Configuration(long index, long term, long time, Collection<RaftMember> newMembers, Collection<RaftMember> oldMembers, boolean force) {
    public Configuration(long index, long term, long time, Collection<RaftMember> newMembers, Collection<RaftMember> oldMembers, boolean force) {
        Preconditions.checkArgument((time > 0L ? 1 : 0) != 0, (Object)"time must be positive");
        Preconditions.checkNotNull(newMembers, (Object)"newMembers cannot be null");
        Preconditions.checkNotNull(oldMembers, (Object)"oldMembers cannot be null");
        this.index = index;
        this.term = term;
        this.time = time;
        this.newMembers = Configuration.copyMembers(newMembers);
        this.oldMembers = Configuration.copyMembers(oldMembers);
        this.force = force;
        if (force) {
            Preconditions.checkArgument((boolean)oldMembers.isEmpty(), (Object)"oldMembers must be empty when force is true");
            Preconditions.checkArgument((!newMembers.isEmpty() ? 1 : 0) != 0, (Object)"newMembers must not be empty when force is true");
        }
    }

    public Configuration(long index, long term, long time, Collection<RaftMember> newMembers, Collection<RaftMember> oldMembers) {
        this(index, term, time, newMembers, oldMembers, false);
    }

    public Configuration(long index, long term, long time, Collection<RaftMember> members) {
        this(index, term, time, members, Collections.emptyList());
    }

    public boolean requiresJointConsensus() {
        return !this.oldMembers.isEmpty();
    }

    public Set<RaftMember> allMembers() {
        return new HashSet<RaftMember>(Stream.concat(this.newMembers.stream(), this.oldMembers.stream()).collect(Collectors.toMap(RaftMember::memberId, Function.identity(), BinaryOperator.maxBy(Comparator.comparing(RaftMember::getType)))).values());
    }

    private static Collection<RaftMember> copyMembers(Collection<RaftMember> members) {
        ImmutableList.Builder copied = ImmutableList.builderWithExpectedSize((int)members.size());
        for (RaftMember member : members) {
            copied.add((Object)new DefaultRaftMember(member.memberId(), member.getType(), member.getLastUpdated()));
        }
        return copied.build();
    }

    public boolean hasMember(MemberId member) {
        return this.allMembers().stream().anyMatch(m -> m.memberId().equals(member));
    }
}

