/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.serializer;

import io.atomix.raft.storage.serializer.ConfigurationEntryDecoder;
import io.atomix.raft.storage.serializer.MemberType;
import io.atomix.raft.storage.serializer.MessageHeaderEncoder;
import io.atomix.raft.storage.serializer.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class ConfigurationEntryEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 8;
    public static final int TEMPLATE_ID = 4;
    public static final int SCHEMA_ID = 8;
    public static final int SCHEMA_VERSION = 3;
    public static final String SEMANTIC_VERSION = "0.1.0";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ConfigurationEntryEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    private final NewMembersEncoder newMembers = new NewMembersEncoder(this);
    private final OldMembersEncoder oldMembers = new OldMembersEncoder(this);

    public int sbeBlockLength() {
        return 8;
    }

    public int sbeTemplateId() {
        return 4;
    }

    public int sbeSchemaId() {
        return 8;
    }

    public int sbeSchemaVersion() {
        return 3;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ConfigurationEntryEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 8);
        return this;
    }

    public ConfigurationEntryEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(8).templateId(4).schemaId(8).version(3);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int timestampId() {
        return 1;
    }

    public static int timestampSinceVersion() {
        return 0;
    }

    public static int timestampEncodingOffset() {
        return 0;
    }

    public static int timestampEncodingLength() {
        return 8;
    }

    public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long timestampNullValue() {
        return -1L;
    }

    public static long timestampMinValue() {
        return 0L;
    }

    public static long timestampMaxValue() {
        return -2L;
    }

    public ConfigurationEntryEncoder timestamp(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static long newMembersId() {
        return 2L;
    }

    public NewMembersEncoder newMembersCount(int count) {
        this.newMembers.wrap(this.buffer, count);
        return this.newMembers;
    }

    public static long oldMembersId() {
        return 3L;
    }

    public OldMembersEncoder oldMembersCount(int count) {
        this.oldMembers.wrap(this.buffer, count);
        return this.oldMembers;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        ConfigurationEntryDecoder decoder = new ConfigurationEntryDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 8, 3);
        return decoder.appendTo(builder);
    }

    public static final class NewMembersEncoder {
        public static final int HEADER_SIZE = 3;
        private final ConfigurationEntryEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        NewMembersEncoder(ConfigurationEntryEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)9, ByteOrder.LITTLE_ENDIAN);
            buffer.putByte(limit + 2, (byte)count);
        }

        public NewMembersEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + NewMembersEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 9;
        }

        public static int typeId() {
            return 1;
        }

        public static int typeSinceVersion() {
            return 0;
        }

        public static int typeEncodingOffset() {
            return 0;
        }

        public static int typeEncodingLength() {
            return 1;
        }

        public static String typeMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public NewMembersEncoder type(MemberType value) {
            this.buffer.putByte(this.offset + 0, (byte)value.value());
            return this;
        }

        public static int updatedId() {
            return 2;
        }

        public static int updatedSinceVersion() {
            return 0;
        }

        public static int updatedEncodingOffset() {
            return 1;
        }

        public static int updatedEncodingLength() {
            return 8;
        }

        public static String updatedMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long updatedNullValue() {
            return Long.MIN_VALUE;
        }

        public static long updatedMinValue() {
            return -9223372036854775807L;
        }

        public static long updatedMaxValue() {
            return Long.MAX_VALUE;
        }

        public NewMembersEncoder updated(long value) {
            this.buffer.putLong(this.offset + 1, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int memberIdId() {
            return 3;
        }

        public static String memberIdCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String memberIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int memberIdHeaderLength() {
            return 4;
        }

        public NewMembersEncoder putMemberId(DirectBuffer src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public NewMembersEncoder putMemberId(byte[] src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public NewMembersEncoder memberId(String value) {
            byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
            int length = bytes.length;
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }
    }

    public static final class OldMembersEncoder {
        public static final int HEADER_SIZE = 3;
        private final ConfigurationEntryEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        OldMembersEncoder(ConfigurationEntryEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)9, ByteOrder.LITTLE_ENDIAN);
            buffer.putByte(limit + 2, (byte)count);
        }

        public OldMembersEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + OldMembersEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 9;
        }

        public static int typeId() {
            return 1;
        }

        public static int typeSinceVersion() {
            return 0;
        }

        public static int typeEncodingOffset() {
            return 0;
        }

        public static int typeEncodingLength() {
            return 1;
        }

        public static String typeMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public OldMembersEncoder type(MemberType value) {
            this.buffer.putByte(this.offset + 0, (byte)value.value());
            return this;
        }

        public static int updatedId() {
            return 2;
        }

        public static int updatedSinceVersion() {
            return 0;
        }

        public static int updatedEncodingOffset() {
            return 1;
        }

        public static int updatedEncodingLength() {
            return 8;
        }

        public static String updatedMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long updatedNullValue() {
            return Long.MIN_VALUE;
        }

        public static long updatedMinValue() {
            return -9223372036854775807L;
        }

        public static long updatedMaxValue() {
            return Long.MAX_VALUE;
        }

        public OldMembersEncoder updated(long value) {
            this.buffer.putLong(this.offset + 1, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int memberIdId() {
            return 3;
        }

        public static String memberIdCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String memberIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int memberIdHeaderLength() {
            return 4;
        }

        public OldMembersEncoder putMemberId(DirectBuffer src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public OldMembersEncoder putMemberId(byte[] src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public OldMembersEncoder memberId(String value) {
            byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
            int length = bytes.length;
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }
    }
}

