/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.raft.protocol.AbstractRaftRequest;
import io.atomix.utils.misc.StringUtils;
import java.nio.ByteBuffer;
import java.util.Objects;

public class InstallRequest
extends AbstractRaftRequest {
    private final long currentTerm;
    private final MemberId leader;
    private final long index;
    private final long term;
    private final int version;
    private final ByteBuffer chunkId;
    private final ByteBuffer nextChunkId;
    private final ByteBuffer data;
    private final boolean initial;
    private final boolean complete;

    public InstallRequest(long currentTerm, MemberId leader, long index, long term, int version, ByteBuffer chunkId, ByteBuffer nextChunkId, ByteBuffer data, boolean initial, boolean complete) {
        this.currentTerm = currentTerm;
        this.leader = leader;
        this.index = index;
        this.version = version;
        this.chunkId = chunkId;
        this.nextChunkId = nextChunkId;
        this.data = data;
        this.initial = initial;
        this.complete = complete;
        this.term = term;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long currentTerm() {
        return this.currentTerm;
    }

    public long term() {
        return this.term;
    }

    public MemberId leader() {
        return this.leader;
    }

    public long index() {
        return this.index;
    }

    public ByteBuffer chunkId() {
        return this.chunkId;
    }

    public ByteBuffer nextChunkId() {
        return this.nextChunkId;
    }

    public boolean isInitial() {
        return this.initial;
    }

    public ByteBuffer data() {
        return this.data;
    }

    public boolean complete() {
        return this.complete;
    }

    public int hashCode() {
        return Objects.hash(this.currentTerm, this.leader, this.index, this.term, this.version, this.chunkId, this.nextChunkId, this.data, this.initial, this.complete);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstallRequest that = (InstallRequest)o;
        return this.currentTerm == that.currentTerm && this.index == that.index && this.term == that.term && this.version == that.version && this.initial == that.initial && this.complete == that.complete && Objects.equals(this.leader, that.leader) && Objects.equals(this.chunkId, that.chunkId) && Objects.equals(this.nextChunkId, that.nextChunkId) && Objects.equals(this.data, that.data);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("currentTerm", this.currentTerm).add("leader", (Object)this.leader).add("index", this.index).add("term", this.term).add("version", this.version).add("chunkId", (Object)StringUtils.printShortBuffer((ByteBuffer)this.chunkId)).add("nextChunkId", (Object)StringUtils.printShortBuffer((ByteBuffer)this.nextChunkId)).add("data", (Object)StringUtils.printShortBuffer((ByteBuffer)this.data)).add("initial", this.initial).add("complete", this.complete).toString();
    }

    @Override
    public MemberId from() {
        return this.leader;
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, InstallRequest> {
        private long currentTerm;
        private MemberId leader;
        private long index;
        private int version;
        private ByteBuffer chunkId;
        private ByteBuffer nextChunkId;
        private ByteBuffer data;
        private boolean complete;
        private boolean initial;
        private long term;

        public Builder withCurrentTerm(long currentTerm) {
            Preconditions.checkArgument((currentTerm > 0L ? 1 : 0) != 0, (Object)"currentTerm must be positive");
            this.currentTerm = currentTerm;
            return this;
        }

        public Builder withLeader(MemberId leader) {
            this.leader = (MemberId)Preconditions.checkNotNull((Object)leader, (Object)"leader cannot be null");
            return this;
        }

        public Builder withTerm(long term) {
            Preconditions.checkArgument((term > 0L ? 1 : 0) != 0, (Object)"term must be positive");
            this.term = term;
            return this;
        }

        public Builder withIndex(long index) {
            Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            this.index = index;
            return this;
        }

        public Builder withVersion(int version) {
            Preconditions.checkArgument((version > 0 ? 1 : 0) != 0, (Object)"version must be positive");
            this.version = version;
            return this;
        }

        public Builder withChunkId(ByteBuffer chunkId) {
            Preconditions.checkNotNull((Object)chunkId, (Object)"chunkId cannot be null");
            this.chunkId = chunkId;
            return this;
        }

        public Builder withNextChunkId(ByteBuffer nextChunkId) {
            this.nextChunkId = nextChunkId;
            return this;
        }

        public Builder withData(ByteBuffer data) {
            this.data = (ByteBuffer)Preconditions.checkNotNull((Object)data, (Object)"data cannot be null");
            return this;
        }

        public Builder withComplete(boolean complete) {
            this.complete = complete;
            return this;
        }

        public Builder withInitial(boolean initial) {
            this.initial = initial;
            return this;
        }

        public InstallRequest build() {
            this.validate();
            return new InstallRequest(this.currentTerm, this.leader, this.index, this.term, this.version, this.chunkId, this.nextChunkId, this.data, this.initial, this.complete);
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkArgument((this.currentTerm > 0L ? 1 : 0) != 0, (Object)"term must be positive");
            Preconditions.checkNotNull((Object)this.leader, (Object)"leader cannot be null");
            Preconditions.checkArgument((this.index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            Preconditions.checkArgument((this.term > 0L ? 1 : 0) != 0, (Object)"snapshotTerm must be positive");
            Preconditions.checkNotNull((Object)this.chunkId, (Object)"chunkId cannot be null");
            Preconditions.checkNotNull((Object)this.data, (Object)"data cannot be null");
        }
    }
}

