/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.RaftMetrics;
import io.atomix.raft.metrics.SnapshotReplicationMetricsDoc;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class SnapshotReplicationMetrics
extends RaftMetrics
implements CloseableSilently {
    private final CompositeMeterRegistry meterRegistry;
    private final AtomicLong count;
    private final AtomicLong duration;

    public SnapshotReplicationMetrics(String partitionName, MeterRegistry wrappedRegistry) {
        super(partitionName);
        this.meterRegistry = MicrometerUtil.wrap((MeterRegistry)Objects.requireNonNull(wrappedRegistry, "meterRegistry cannot be null"), (Tags)Tags.of((String)MicrometerUtil.PartitionKeyNames.PARTITION.asString(), (String)this.partition));
        this.count = new AtomicLong(0L);
        Gauge.builder((String)SnapshotReplicationMetricsDoc.COUNT.getName(), this.count::get).description(SnapshotReplicationMetricsDoc.COUNT.getDescription()).tags(new String[]{"partitionGroupName", this.partitionGroupName}).register((MeterRegistry)this.meterRegistry);
        this.duration = new AtomicLong(0L);
        Gauge.builder((String)SnapshotReplicationMetricsDoc.DURATION.getName(), this.duration::get).description(SnapshotReplicationMetricsDoc.DURATION.getDescription()).tags(new String[]{"partitionGroupName", this.partitionGroupName}).register((MeterRegistry)this.meterRegistry);
    }

    public void incrementCount() {
        this.count.incrementAndGet();
    }

    public void decrementCount() {
        this.count.decrementAndGet();
    }

    public void setCount(int value) {
        this.count.set(value);
    }

    public void observeDuration(long durationMillis) {
        this.duration.set(durationMillis);
    }

    public void close() {
        MicrometerUtil.discard((CompositeMeterRegistry)this.meterRegistry);
    }
}

