/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.raft.RaftError;

public abstract class RaftException
extends RuntimeException {
    private final RaftError.Type type;

    protected RaftException(RaftError.Type type, String message, Object ... args) {
        super(message != null ? String.format(message, args) : null);
        if (type == null) {
            throw new NullPointerException("type cannot be null");
        }
        this.type = type;
    }

    protected RaftException(RaftError.Type type, Throwable cause, String message, Object ... args) {
        super(String.format(message, args), cause);
        if (type == null) {
            throw new NullPointerException("type cannot be null");
        }
        this.type = type;
    }

    protected RaftException(RaftError.Type type, Throwable cause) {
        super(cause);
        if (type == null) {
            throw new NullPointerException("type cannot be null");
        }
        this.type = type;
    }

    public RaftError.Type getType() {
        return this.type;
    }

    public static class AppendFailureException
    extends RaftException {
        private final long index;

        public AppendFailureException(long index, String message) {
            super(RaftError.Type.COMMAND_FAILURE, message, new Object[0]);
            this.index = index;
        }

        public long getIndex() {
            return this.index;
        }
    }

    public static class ConfigurationException
    extends RaftException {
        public ConfigurationException(Throwable throwable, String message, Object ... args) {
            super(RaftError.Type.CONFIGURATION_ERROR, throwable, message, args);
        }
    }

    public static class ProtocolException
    extends RaftException {
        public ProtocolException(String message, Object ... args) {
            super(RaftError.Type.PROTOCOL_ERROR, message, args);
        }
    }

    public static class NoLeader
    extends RaftException {
        public NoLeader(String message, Object ... args) {
            super(RaftError.Type.NO_LEADER, message, args);
        }
    }
}

