/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PartitionMetadata {
    private final PartitionId id;
    private final Set<MemberId> members;
    private final Map<MemberId, Integer> priority;
    private final int targetPriority;
    private final MemberId primary;

    public PartitionMetadata(PartitionId id, Set<MemberId> members, Map<MemberId, Integer> priority, int targetPriority, MemberId primary) {
        this.id = id;
        this.members = members;
        this.priority = priority;
        this.targetPriority = targetPriority;
        this.primary = primary;
    }

    public PartitionId id() {
        return this.id;
    }

    public Collection<MemberId> members() {
        return this.members;
    }

    public int getPriority(MemberId member) {
        return this.priority.getOrDefault(member, -1);
    }

    public Optional<MemberId> getPrimary() {
        return Optional.ofNullable(this.primary);
    }

    public int getTargetPriority() {
        return this.targetPriority;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.members != null ? this.members.hashCode() : 0);
        result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
        result = 31 * result + this.targetPriority;
        result = 31 * result + (this.primary != null ? this.primary.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionMetadata that = (PartitionMetadata)o;
        if (this.targetPriority != that.targetPriority) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!Objects.equals(this.members, that.members)) {
            return false;
        }
        if (!Objects.equals(this.priority, that.priority)) {
            return false;
        }
        return Objects.equals(this.primary, that.primary);
    }

    public String toString() {
        return "PartitionMetadata{id=" + String.valueOf(this.id) + ", primary=" + String.valueOf(this.primary) + ", members=" + String.valueOf(this.members) + ", priority=" + String.valueOf(this.priority) + ", targetPriority=" + this.targetPriority + "}";
    }
}

