/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.protocol;

import io.atomix.cluster.protocol.SwimMembershipProtocolMetricsDoc;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class SwimMembershipProtocolMetrics {
    private final Map<String, AtomicLong> incarnationNumbers = new ConcurrentHashMap<String, AtomicLong>();
    private final MeterRegistry registry;

    public SwimMembershipProtocolMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    public void updateMemberIncarnationNumber(String member, long incarnationNumber) {
        this.registerIncarnationNumberGauge(member).set(incarnationNumber);
    }

    private AtomicLong registerIncarnationNumberGauge(String member) {
        AtomicLong counter = this.incarnationNumbers.get(member);
        if (counter == null) {
            AtomicLong finalCounter = new AtomicLong(0L);
            AtomicLong inside = this.incarnationNumbers.computeIfAbsent(member, unused -> finalCounter);
            if (inside == finalCounter) {
                Gauge.builder((String)SwimMembershipProtocolMetricsDoc.MEMBERS_INCARNATION_NUMBER.getName(), inside::get).description(SwimMembershipProtocolMetricsDoc.MEMBERS_INCARNATION_NUMBER.getDescription()).tags(new String[]{SwimMembershipProtocolMetricsDoc.SwimKeyNames.MEMBER_ID.asString(), member}).register(this.registry);
            }
            return inside;
        }
        return counter;
    }
}

