/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.impl.NettyDnsMetricsDoc;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsResponseCode;
import io.netty.resolver.dns.DnsQueryLifecycleObserver;
import java.net.InetSocketAddress;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class NettyDnsMetrics
implements DnsQueryLifecycleObserver {
    private final Counter error;
    private final Counter written;
    private final Counter succeded;
    private final Meter.MeterProvider<Counter> failed;

    NettyDnsMetrics(MeterRegistry registry) {
        this.error = Counter.builder((String)NettyDnsMetricsDoc.ERROR.getName()).description(NettyDnsMetricsDoc.ERROR.getDescription()).register(registry);
        this.written = Counter.builder((String)NettyDnsMetricsDoc.WRITTEN.getName()).description(NettyDnsMetricsDoc.WRITTEN.getDescription()).register(registry);
        this.succeded = Counter.builder((String)NettyDnsMetricsDoc.SUCCESS.getName()).description(NettyDnsMetricsDoc.SUCCESS.getDescription()).register(registry);
        this.failed = Counter.builder((String)NettyDnsMetricsDoc.FAILED.getName()).description(NettyDnsMetricsDoc.FAILED.getDescription()).withRegistry(registry);
    }

    public void queryWritten(InetSocketAddress dnsServerAddress, ChannelFuture future) {
        this.written.increment();
    }

    public void queryCancelled(int queriesRemaining) {
    }

    public DnsQueryLifecycleObserver queryRedirected(List<InetSocketAddress> nameServers) {
        return this;
    }

    public DnsQueryLifecycleObserver queryCNAMEd(DnsQuestion cnameQuestion) {
        return this;
    }

    public DnsQueryLifecycleObserver queryNoAnswer(DnsResponseCode code) {
        ((Counter)this.failed.withTag(NettyDnsMetricsDoc.NettyDnsKeyName.CODE.asString(), code.toString())).increment();
        return this;
    }

    public void queryFailed(Throwable cause) {
        this.error.increment();
    }

    public void querySucceed() {
        this.succeded.increment();
    }
}

