/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import com.google.common.collect.Maps;
import io.atomix.cluster.messaging.MessagingException;
import io.atomix.cluster.messaging.impl.ClientConnection;
import io.atomix.cluster.messaging.impl.ProtocolReply;
import io.camunda.zeebe.util.StringUtil;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractClientConnection
implements ClientConnection {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Map<Long, CompletableFuture<byte[]>> responseFutures = Maps.newConcurrentMap();

    AbstractClientConnection() {
    }

    @Override
    public void dispatch(ProtocolReply message) {
        CompletableFuture<byte[]> responseFuture = this.responseFutures.remove(message.id());
        if (responseFuture != null) {
            if (message.status() == ProtocolReply.Status.OK) {
                responseFuture.complete(message.payload());
            } else if (message.status() == ProtocolReply.Status.ERROR_NO_HANDLER) {
                String subject = this.extractMessage(message);
                responseFuture.completeExceptionally(new MessagingException.NoRemoteHandler(subject));
            } else if (message.status() == ProtocolReply.Status.ERROR_HANDLER_EXCEPTION) {
                String exceptionMessage = this.extractMessage(message);
                responseFuture.completeExceptionally(new MessagingException.RemoteHandlerFailure(exceptionMessage));
            } else if (message.status() == ProtocolReply.Status.PROTOCOL_EXCEPTION) {
                responseFuture.completeExceptionally(new MessagingException.ProtocolException());
            }
        } else {
            this.log.debug("Received a reply for message id:[{}] but was unable to locate the request handle", (Object)message.id());
        }
    }

    private String extractMessage(ProtocolReply message) {
        byte[] payload = message.payload();
        String exceptionMessage = null;
        if (payload != null && payload.length > 0) {
            exceptionMessage = StringUtil.fromBytes((byte[])payload);
        }
        return exceptionMessage;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            for (CompletableFuture<byte[]> responseFuture : this.responseFutures.values()) {
                responseFuture.completeExceptionally(new MessagingException.ConnectionClosed(String.format("Connection %s was closed", this)));
            }
        }
    }

    protected CompletableFuture<byte[]> awaitResponseForRequestWithId(long id) {
        CompletableFuture responseFuture = this.responseFutures.computeIfAbsent(id, ignored -> new CompletableFuture());
        responseFuture.whenComplete((result, error) -> this.responseFutures.remove(id));
        return responseFuture;
    }
}

