/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.zeebe;

import io.atomix.raft.RaftCommitListener;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.zeebe.ZeebeLogAppender;
import io.atomix.raft.zeebe.util.TestAppender;
import io.atomix.raft.zeebe.util.ZeebeTestHelper;
import io.atomix.raft.zeebe.util.ZeebeTestNode;
import io.camunda.zeebe.test.util.junit.AutoCloseResources;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ObjectAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ZeebeIT {
    @AutoCloseResources.AutoCloseResource
    static MeterRegistry meterRegistry = new SimpleMeterRegistry();
    private static final int ENTRIES_PER_SEGMENT = 35;
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Parameterized.Parameter
    public String name;
    @Parameterized.Parameter(value=1)
    public Collection<Function<TemporaryFolder, ZeebeTestNode>> nodeSuppliers;
    private final TestAppender appenderWrapper = new TestAppender();
    private Collection<ZeebeTestNode> nodes;
    private ZeebeTestHelper helper;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"single node", Collections.singleton(ZeebeIT.provideNode(1))}, {"three nodes", Arrays.asList(ZeebeIT.provideNode(1), ZeebeIT.provideNode(2), ZeebeIT.provideNode(3))});
    }

    private static Function<TemporaryFolder, ZeebeTestNode> provideNode(int id) {
        return tmp -> new ZeebeTestNode(id, ZeebeIT.newFolderUnchecked(tmp, id), meterRegistry);
    }

    private static File newFolderUnchecked(TemporaryFolder tmp, int id) {
        try {
            return tmp.newFolder(String.valueOf(id));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Before
    public void setUp() throws Exception {
        this.nodes = this.buildNodes();
        this.helper = new ZeebeTestHelper(this.nodes);
        this.start();
    }

    @After
    public void tearDown() throws Exception {
        this.stop();
    }

    @Test
    public void shouldAppendAndReplicate() {
        boolean partitionId = true;
        ZeebeLogAppender appender = this.helper.awaitLeaderAppender(1);
        IndexedRaftLogEntry appended = this.appenderWrapper.append(appender, 0L, 0L, this.getIntAsBytes(0));
        this.helper.awaitAllContain(1, appended);
    }

    @Test
    public void shouldFailover() {
        Assumptions.assumeThat((this.nodes.size() > 1 ? 1 : 0) != 0).isTrue();
        boolean partitionId = true;
        ZeebeTestNode originalLeader = this.helper.awaitLeader(1);
        ArrayList<ZeebeTestNode> followers = new ArrayList<ZeebeTestNode>(this.nodes);
        followers.remove(originalLeader);
        originalLeader.stop().join();
        ZeebeTestNode newLeader = this.helper.awaitLeader(1, followers);
        originalLeader.start(this.nodes).join();
        ((ObjectAssert)Assertions.assertThat((Object)this.helper.awaitLeader(1)).isNotEqualTo((Object)originalLeader)).isEqualTo((Object)newLeader);
    }

    @Test
    public void shouldAppendAllEntriesEvenWithFollowerFailures() {
        Assumptions.assumeThat((this.nodes.size() > 1 ? 1 : 0) != 0).isTrue();
        boolean partitionId = true;
        ZeebeTestNode leader = this.helper.awaitLeader(1);
        ZeebeLogAppender appender = this.helper.awaitLeaderAppender(1);
        List<ZeebeTestNode> followers = this.nodes.stream().filter(node -> !node.equals(leader)).toList();
        ArrayList<IndexedRaftLogEntry> entries = new ArrayList<IndexedRaftLogEntry>();
        for (int i = 0; i < followers.size(); ++i) {
            ZeebeTestNode follower = followers.get(i);
            List<ZeebeTestNode> others = this.nodes.stream().filter(node -> !node.equals(follower)).collect(Collectors.toList());
            follower.stop().join();
            entries.add(i, this.appenderWrapper.append(appender, i, i, this.getIntAsBytes(i)));
            this.helper.awaitAllContains(others, 1, (IndexedRaftLogEntry)entries.get(i));
            follower.start(this.nodes).join();
        }
        for (IndexedRaftLogEntry entry : entries) {
            this.helper.awaitAllContain(1, entry);
        }
    }

    @Test
    public void shouldNotifyCommitListeners() {
        boolean partitionId = true;
        ZeebeLogAppender appender = this.helper.awaitLeaderAppender(1);
        Map listeners = this.nodes.stream().collect(Collectors.toMap(Function.identity(), node -> {
            CommitListener listener = new CommitListener();
            node.getPartitionServer(1).addCommitListener((RaftCommitListener)listener);
            return listener;
        }));
        for (int i = 0; i < 5; ++i) {
            IndexedRaftLogEntry entry = this.appenderWrapper.append(appender, i, i, this.getIntAsBytes(i));
            this.helper.awaitAllContains(this.nodes, 1, entry);
            for (ZeebeTestNode node2 : this.nodes) {
                CommitListener listener = listeners.get(node2);
                this.helper.await(() -> listener.lastCommitted.get() == entry.index());
            }
        }
    }

    private ByteBuffer getIntAsBytes(int value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(value).flip();
        return buffer;
    }

    private Collection<ZeebeTestNode> buildNodes() {
        return this.nodeSuppliers.stream().map(supplier -> (ZeebeTestNode)supplier.apply(this.temporaryFolder)).collect(Collectors.toList());
    }

    private void start() throws ExecutionException, InterruptedException, TimeoutException {
        CompletableFuture.allOf((CompletableFuture[])this.nodes.stream().map(n -> n.start(this.nodes)).toArray(CompletableFuture[]::new)).get(30L, TimeUnit.SECONDS);
    }

    private void stop() throws InterruptedException, ExecutionException, TimeoutException {
        CompletableFuture.allOf((CompletableFuture[])this.nodes.stream().map(ZeebeTestNode::stop).toArray(CompletableFuture[]::new)).get(30L, TimeUnit.SECONDS);
    }

    static class CommitListener
    implements RaftCommitListener {
        private final AtomicLong lastCommitted = new AtomicLong();

        CommitListener() {
        }

        public void onCommit(long index) {
            this.lastCommitted.set(index);
        }
    }
}

