/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.system;

import io.atomix.cluster.MemberId;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import io.atomix.raft.storage.RaftStorage;
import io.atomix.raft.storage.system.Configuration;
import io.atomix.raft.storage.system.MetaStore;
import io.camunda.zeebe.test.util.junit.AutoCloseResources;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class MetaStoreTest {
    @TempDir
    Path temporaryFolder;
    @AutoCloseResources.AutoCloseResource
    MeterRegistry meterRegistry = new SimpleMeterRegistry();
    private MetaStore metaStore;
    private RaftStorage storage;

    MetaStoreTest() {
    }

    @BeforeEach
    public void setup() throws IOException {
        this.storage = RaftStorage.builder((MeterRegistry)this.meterRegistry).withDirectory(this.temporaryFolder.toFile()).build();
        this.metaStore = new MetaStore(this.storage, this.meterRegistry);
    }

    @AfterEach
    public void tearDown() {
        this.metaStore.close();
    }

    @Nested
    final class ConfigurationTest {
        ConfigurationTest() {
        }

        @Test
        void shouldLoadEmptyConfig() {
            Assertions.assertThat((Object)MetaStoreTest.this.metaStore.loadConfiguration()).isNull();
        }

        @ParameterizedTest
        @MethodSource(value={"provideConfigurations"})
        void shouldStoreAndLoadConfiguration(Configuration config) {
            MetaStoreTest.this.metaStore.storeConfiguration(config);
            Configuration readConfig = MetaStoreTest.this.metaStore.loadConfiguration();
            Assertions.assertThat((Object)readConfig).isEqualTo((Object)config);
        }

        @Test
        void shouldLoadExistingConfiguration() throws IOException {
            Configuration config = ConfigurationTest.getConfiguration(1L, 2L);
            MetaStoreTest.this.metaStore.storeConfiguration(config);
            MetaStoreTest.this.metaStore.close();
            MetaStoreTest.this.metaStore = new MetaStore(MetaStoreTest.this.storage, MetaStoreTest.this.meterRegistry);
            Configuration readConfig = MetaStoreTest.this.metaStore.loadConfiguration();
            Assertions.assertThat((Object)readConfig).isEqualTo((Object)config);
        }

        @Test
        void shouldLoadLatestConfigurationAfterRestart() throws IOException {
            Configuration firstConfig = ConfigurationTest.getConfiguration(1L, 2L);
            MetaStoreTest.this.metaStore.storeConfiguration(firstConfig);
            Configuration secondConfig = ConfigurationTest.getConfiguration(3L, 4L);
            MetaStoreTest.this.metaStore.storeConfiguration(secondConfig);
            MetaStoreTest.this.metaStore.close();
            MetaStoreTest.this.metaStore = new MetaStore(MetaStoreTest.this.storage, MetaStoreTest.this.meterRegistry);
            Configuration readConfig = MetaStoreTest.this.metaStore.loadConfiguration();
            Assertions.assertThat((Object)readConfig).isEqualTo((Object)secondConfig);
        }

        @Test
        void shouldStoreConfigurationMultipleTimes() {
            Configuration firstConfig = ConfigurationTest.getConfiguration(1L, 2L);
            MetaStoreTest.this.metaStore.storeConfiguration(firstConfig);
            Configuration secondConfig = ConfigurationTest.getConfiguration(3L, 4L);
            MetaStoreTest.this.metaStore.storeConfiguration(secondConfig);
            Configuration readConfig = MetaStoreTest.this.metaStore.loadConfiguration();
            Assertions.assertThat((Object)readConfig).isEqualTo((Object)secondConfig);
        }

        private static Configuration getConfiguration(long index, long term) {
            return new Configuration(index, term, 1234L, ConfigurationTest.getMembers("0", "1"));
        }

        private static ArrayList<RaftMember> getMembers(String m0, String m1) {
            return new ArrayList<DefaultRaftMember>(Set.of(new DefaultRaftMember(MemberId.from((String)m0), RaftMember.Type.ACTIVE, Instant.ofEpochMilli(12345L)), new DefaultRaftMember(MemberId.from((String)m1), RaftMember.Type.PASSIVE, Instant.ofEpochMilli(12346L))));
        }

        private static Stream<Arguments> provideConfigurations() {
            return Stream.of(Arguments.of((Object[])new Object[]{Named.named((String)"default", (Object)ConfigurationTest.getConfiguration(2L, 3L))}), Arguments.of((Object[])new Object[]{Named.named((String)"joint consensus", (Object)new Configuration(2L, 3L, 1234L, ConfigurationTest.getMembers("0", "2"), ConfigurationTest.getMembers("0", "1")))}), Arguments.of((Object[])new Object[]{Named.named((String)"force configuration", (Object)new Configuration(2L, 3L, 1235L, ConfigurationTest.getMembers("0", "3"), List.of(), true))}));
        }
    }

    @Nested
    final class MetadataTest {
        MetadataTest() {
        }

        @Test
        void shouldStoreAndLoadTerm() {
            MetaStoreTest.this.metaStore.storeTerm(2L);
            Assertions.assertThat((long)MetaStoreTest.this.metaStore.loadTerm()).isEqualTo(2L);
        }

        @Test
        void shouldStoreAndLoadVote() {
            MetaStoreTest.this.metaStore.storeVote(new MemberId("id"));
            Assertions.assertThat((String)((String)((Object)MetaStoreTest.this.metaStore.loadVote().id()))).isEqualTo("id");
        }

        @Test
        void shouldLoadExistingTerm() throws IOException {
            MetaStoreTest.this.metaStore.storeTerm(2L);
            MetaStoreTest.this.metaStore.close();
            MetaStoreTest.this.metaStore = new MetaStore(MetaStoreTest.this.storage, MetaStoreTest.this.meterRegistry);
            Assertions.assertThat((long)MetaStoreTest.this.metaStore.loadTerm()).isEqualTo(2L);
        }

        @Test
        void shouldLoadExistingVote() throws IOException {
            MetaStoreTest.this.metaStore.storeVote(new MemberId("id"));
            MetaStoreTest.this.metaStore.close();
            MetaStoreTest.this.metaStore = new MetaStore(MetaStoreTest.this.storage, MetaStoreTest.this.meterRegistry);
            Assertions.assertThat((String)((String)((Object)MetaStoreTest.this.metaStore.loadVote().id()))).isEqualTo("id");
        }

        @Test
        void shouldLoadEmptyMeta() {
            Assertions.assertThat((Comparable)MetaStoreTest.this.metaStore.loadVote()).isNull();
            Assertions.assertThat((long)MetaStoreTest.this.metaStore.loadTerm()).isEqualTo(0L);
        }

        @Test
        void shouldLoadEmptyVoteWhenTermExists() {
            MetaStoreTest.this.metaStore.storeTerm(1L);
            Assertions.assertThat((Comparable)MetaStoreTest.this.metaStore.loadVote()).isNull();
        }

        @Test
        void shouldLoadLatestTermAndVoteAfterRestart() throws IOException {
            MetaStoreTest.this.metaStore.storeTerm(2L);
            MetaStoreTest.this.metaStore.storeVote(MemberId.from((String)"0"));
            MetaStoreTest.this.metaStore.storeTerm(3L);
            MetaStoreTest.this.metaStore.storeVote(MemberId.from((String)"1"));
            MetaStoreTest.this.metaStore.close();
            MetaStoreTest.this.metaStore = new MetaStore(MetaStoreTest.this.storage, MetaStoreTest.this.meterRegistry);
            Assertions.assertThat((long)MetaStoreTest.this.metaStore.loadTerm()).isEqualTo(3L);
            Assertions.assertThat((String)((String)((Object)MetaStoreTest.this.metaStore.loadVote().id()))).isEqualTo("1");
        }

        @Test
        void shouldStoreAndLoadLastFlushedIndex() {
            MetaStoreTest.this.metaStore.storeLastFlushedIndex(5L);
            Assertions.assertThat((long)MetaStoreTest.this.metaStore.loadLastFlushedIndex()).isEqualTo(5L);
        }

        @Test
        void shouldStoreAndLoadLastFlushedIndexAfterRestart() throws IOException {
            MetaStoreTest.this.metaStore.storeLastFlushedIndex(5L);
            MetaStoreTest.this.metaStore.close();
            MetaStoreTest.this.metaStore = new MetaStore(MetaStoreTest.this.storage, MetaStoreTest.this.meterRegistry);
            Assertions.assertThat((long)MetaStoreTest.this.metaStore.loadLastFlushedIndex()).isEqualTo(5L);
        }

        @Test
        void shouldLoadLatestWrittenIndex() throws IOException {
            MetaStoreTest.this.metaStore.storeLastFlushedIndex(5L);
            MetaStoreTest.this.metaStore.storeLastFlushedIndex(7L);
            Assertions.assertThat((long)MetaStoreTest.this.metaStore.loadLastFlushedIndex()).isEqualTo(7L);
            MetaStoreTest.this.metaStore.storeLastFlushedIndex(8L);
            MetaStoreTest.this.metaStore.close();
            MetaStoreTest.this.metaStore = new MetaStore(MetaStoreTest.this.storage, MetaStoreTest.this.meterRegistry);
            Assertions.assertThat((long)MetaStoreTest.this.metaStore.loadLastFlushedIndex()).isEqualTo(8L);
        }

        @Test
        void shouldStoreAndLoadAllMetadata() {
            MetaStoreTest.this.metaStore.storeTerm(1L);
            MetaStoreTest.this.metaStore.storeLastFlushedIndex(2L);
            MetaStoreTest.this.metaStore.storeVote(MemberId.from((String)"a"));
            Assertions.assertThat((long)MetaStoreTest.this.metaStore.loadTerm()).isEqualTo(1L);
            Assertions.assertThat((long)MetaStoreTest.this.metaStore.loadLastFlushedIndex()).isEqualTo(2L);
            Assertions.assertThat((Comparable)MetaStoreTest.this.metaStore.loadVote()).isEqualTo((Object)MemberId.from((String)"a"));
        }
    }
}

