/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.roles;

import io.atomix.raft.ControllableRaftContexts;
import io.atomix.raft.RaftServer;
import io.camunda.zeebe.test.util.junit.RegressionTest;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;

class CandidateRoleTest {
    private ControllableRaftContexts raftContexts;
    @TempDir
    private Path raftDataDirectory;

    CandidateRoleTest() {
    }

    @BeforeEach
    public void before() throws Exception {
        this.raftContexts = new ControllableRaftContexts(3);
        this.raftContexts.setup(this.raftDataDirectory, new Random(1L));
    }

    @AfterEach
    public void shutdown() throws IOException {
        this.raftContexts.shutdown();
    }

    @RegressionTest(value="https://github.com/camunda/zeebe/issues/11665")
    void shouldTransitionToFollowerWhenElectionTimesOut() {
        boolean chosenCandidate = false;
        this.raftContexts.tickElectionTimeout(0);
        this.raftContexts.tickHeartbeatTimeout(0);
        int steps = 100;
        while (!this.isCandidate(0)) {
            this.raftContexts.tickHeartbeatTimeout();
            this.raftContexts.processAllMessage();
            this.raftContexts.runUntilDone();
            if (steps-- >= 0) continue;
        }
        Assertions.assertThat((boolean)this.isCandidate(0)).isTrue();
        steps = 100;
        while (this.isCandidate(0)) {
            this.raftContexts.tickHeartbeatTimeout(0);
            if (steps-- >= 0) continue;
        }
        Assertions.assertThat((Comparable)this.raftContexts.getRaftContext(0).getRole()).isEqualTo((Object)RaftServer.Role.FOLLOWER);
    }

    private boolean isCandidate(int expectedCandidate) {
        return this.raftContexts.getRaftContext(expectedCandidate).getRole() == RaftServer.Role.CANDIDATE;
    }
}

