/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import io.atomix.cluster.MemberId;
import io.atomix.raft.protocol.AppendRequest;
import io.atomix.raft.protocol.AppendResponse;
import io.atomix.raft.protocol.ConfigureRequest;
import io.atomix.raft.protocol.ConfigureResponse;
import io.atomix.raft.protocol.ForceConfigureRequest;
import io.atomix.raft.protocol.ForceConfigureResponse;
import io.atomix.raft.protocol.InstallRequest;
import io.atomix.raft.protocol.InstallResponse;
import io.atomix.raft.protocol.JoinRequest;
import io.atomix.raft.protocol.JoinResponse;
import io.atomix.raft.protocol.LeaveRequest;
import io.atomix.raft.protocol.LeaveResponse;
import io.atomix.raft.protocol.PollRequest;
import io.atomix.raft.protocol.PollResponse;
import io.atomix.raft.protocol.RaftServerProtocol;
import io.atomix.raft.protocol.ReconfigureRequest;
import io.atomix.raft.protocol.ReconfigureResponse;
import io.atomix.raft.protocol.TransferRequest;
import io.atomix.raft.protocol.TransferResponse;
import io.atomix.raft.protocol.VersionedAppendRequest;
import io.atomix.raft.protocol.VoteRequest;
import io.atomix.raft.protocol.VoteResponse;
import io.camunda.zeebe.util.collection.Tuple;
import java.net.ConnectException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllableRaftServerProtocol
implements RaftServerProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(ControllableRaftServerProtocol.class);
    private Function<ConfigureRequest, CompletableFuture<ConfigureResponse>> configureHandler;
    private Function<ReconfigureRequest, CompletableFuture<ReconfigureResponse>> reconfigureHandler;
    private Function<ForceConfigureRequest, CompletableFuture<ForceConfigureResponse>> forceConfigureHandler;
    private Function<JoinRequest, CompletableFuture<JoinResponse>> joinHandler;
    private Function<LeaveRequest, CompletableFuture<LeaveResponse>> leaveHandler;
    private Function<InstallRequest, CompletableFuture<InstallResponse>> installHandler;
    private Function<TransferRequest, CompletableFuture<TransferResponse>> transferHandler;
    private Function<PollRequest, CompletableFuture<PollResponse>> pollHandler;
    private Function<VoteRequest, CompletableFuture<VoteResponse>> voteHandler;
    private Function<VersionedAppendRequest, CompletableFuture<AppendResponse>> appendHandler;
    private final Map<MemberId, ControllableRaftServerProtocol> servers;
    private final Map<MemberId, Queue<Tuple<Runnable, CompletableFuture<?>>>> messageQueue;
    private final MemberId localMemberId;
    private final Map<CompletableFuture<?>, Long> timeoutQueue = new HashMap();
    private long currentTime = 0L;
    private final long requestTimeoutMillis = Duration.ofSeconds(5L).toMillis();

    public ControllableRaftServerProtocol(MemberId memberId, Map<MemberId, ControllableRaftServerProtocol> servers, Map<MemberId, Queue<Tuple<Runnable, CompletableFuture<?>>>> messageQueue) {
        this.servers = servers;
        this.messageQueue = messageQueue;
        this.localMemberId = memberId;
        messageQueue.put(memberId, new LinkedList());
        servers.put(memberId, this);
    }

    public void receiveNextMessage() {
        Queue<Tuple<Runnable, CompletableFuture<?>>> rcvQueue = this.messageQueue.get(this.localMemberId);
        if (!rcvQueue.isEmpty()) {
            Tuple<Runnable, CompletableFuture<?>> message = rcvQueue.poll();
            ((Runnable)message.getLeft()).run();
            this.timeoutQueue.remove(message.getRight());
        }
    }

    public void receiveAll() {
        Queue<Tuple<Runnable, CompletableFuture<?>>> rcvQueue = this.messageQueue.get(this.localMemberId);
        while (!rcvQueue.isEmpty()) {
            Tuple<Runnable, CompletableFuture<?>> message = rcvQueue.poll();
            ((Runnable)message.getLeft()).run();
            this.timeoutQueue.remove(message.getRight());
        }
    }

    public void dropNextMessage() {
        Tuple nextMessage = (Tuple)this.messageQueue.computeIfAbsent(this.localMemberId, t -> new LinkedList()).poll();
        if (nextMessage != null) {
            Optional.ofNullable((CompletableFuture)nextMessage.getRight()).ifPresent(f -> {
                LOG.info("Dropped a message to {}", (Object)this.localMemberId.id());
                TimeoutException e = new TimeoutException();
                e.setStackTrace(new StackTraceElement[0]);
                f.completeExceptionally(e);
            });
        }
    }

    ControllableRaftServerProtocol server(MemberId memberId) {
        return this.servers.get(memberId);
    }

    private void send(MemberId memberId, Runnable requestHandler, CompletableFuture<?> responseFuture) {
        Tuple message = new Tuple((Object)requestHandler, responseFuture);
        this.messageQueue.computeIfAbsent(memberId, m -> new LinkedList()).add(message);
        this.addTimeOut(responseFuture);
    }

    private void addTimeOut(CompletableFuture<?> responseFuture) {
        if (responseFuture != null) {
            this.timeoutQueue.put(responseFuture, this.currentTime + this.requestTimeoutMillis);
        }
    }

    public void tick(long timeoutMillis) {
        this.currentTime += timeoutMillis;
        Iterator<Map.Entry<CompletableFuture<?>, Long>> iter = this.timeoutQueue.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<CompletableFuture<?>, Long> entry = iter.next();
            Long deadline = entry.getValue();
            if (this.currentTime < deadline) continue;
            CompletableFuture<?> messageFuture = entry.getKey();
            if (!messageFuture.isDone()) {
                TimeoutException timeout = new TimeoutException();
                timeout.setStackTrace(new StackTraceElement[0]);
                messageFuture.completeExceptionally(timeout);
            }
            iter.remove();
        }
    }

    public CompletableFuture<ConfigureResponse> configure(MemberId memberId, ConfigureRequest request) {
        CompletableFuture<ConfigureResponse> responseFuture = new CompletableFuture<ConfigureResponse>();
        this.send(memberId, () -> ((CompletableFuture)this.getServer(memberId).thenCompose(listener -> listener.configure(request))).thenAccept(response -> this.send(this.localMemberId, () -> responseFuture.complete((ConfigureResponse)response), null)), responseFuture);
        return responseFuture;
    }

    public CompletableFuture<ReconfigureResponse> reconfigure(MemberId memberId, ReconfigureRequest request) {
        CompletableFuture<ReconfigureResponse> responseFuture = new CompletableFuture<ReconfigureResponse>();
        this.send(memberId, () -> ((CompletableFuture)this.getServer(memberId).thenCompose(listener -> listener.reconfigure(request))).thenAccept(response -> this.send(this.localMemberId, () -> responseFuture.complete((ReconfigureResponse)response), null)), responseFuture);
        return responseFuture;
    }

    public CompletableFuture<ForceConfigureResponse> forceConfigure(MemberId memberId, ForceConfigureRequest request) {
        CompletableFuture<ForceConfigureResponse> responseFuture = new CompletableFuture<ForceConfigureResponse>();
        this.send(memberId, () -> ((CompletableFuture)this.getServer(memberId).thenCompose(listener -> listener.forceConfigure(request))).thenAccept(response -> this.send(this.localMemberId, () -> responseFuture.complete((ForceConfigureResponse)response), null)), responseFuture);
        return responseFuture;
    }

    public CompletableFuture<JoinResponse> join(MemberId memberId, JoinRequest request) {
        CompletableFuture<JoinResponse> responseFuture = new CompletableFuture<JoinResponse>();
        this.send(memberId, () -> ((CompletableFuture)this.getServer(memberId).thenCompose(listener -> listener.join(request))).thenAccept(response -> this.send(this.localMemberId, () -> responseFuture.complete((JoinResponse)response), null)), responseFuture);
        return responseFuture;
    }

    public CompletableFuture<LeaveResponse> leave(MemberId memberId, LeaveRequest request) {
        CompletableFuture<LeaveResponse> responseFuture = new CompletableFuture<LeaveResponse>();
        this.send(memberId, () -> ((CompletableFuture)this.getServer(memberId).thenCompose(listener -> listener.leave(request))).thenAccept(response -> this.send(this.localMemberId, () -> responseFuture.complete((LeaveResponse)response), null)), responseFuture);
        return responseFuture;
    }

    public CompletableFuture<InstallResponse> install(MemberId memberId, InstallRequest request) {
        CompletableFuture<InstallResponse> responseFuture = new CompletableFuture<InstallResponse>();
        this.send(memberId, () -> ((CompletableFuture)this.getServer(memberId).thenCompose(listener -> listener.install(request))).thenAccept(response -> this.send(this.localMemberId, () -> responseFuture.complete((InstallResponse)response), null)), responseFuture);
        return responseFuture;
    }

    public CompletableFuture<TransferResponse> transfer(MemberId memberId, TransferRequest request) {
        CompletableFuture<TransferResponse> responseFuture = new CompletableFuture<TransferResponse>();
        this.send(memberId, () -> ((CompletableFuture)this.getServer(memberId).thenCompose(listener -> listener.transfer(request))).thenAccept(response -> this.send(this.localMemberId, () -> responseFuture.complete((TransferResponse)response), null)), responseFuture);
        return responseFuture;
    }

    public CompletableFuture<PollResponse> poll(MemberId memberId, PollRequest request) {
        CompletableFuture<PollResponse> responseFuture = new CompletableFuture<PollResponse>();
        this.send(memberId, () -> ((CompletableFuture)this.getServer(memberId).thenCompose(listener -> listener.poll(request))).thenAccept(response -> this.send(this.localMemberId, () -> responseFuture.complete((PollResponse)response), null)), responseFuture);
        return responseFuture;
    }

    public CompletableFuture<VoteResponse> vote(MemberId memberId, VoteRequest request) {
        CompletableFuture<VoteResponse> responseFuture = new CompletableFuture<VoteResponse>();
        this.send(memberId, () -> ((CompletableFuture)this.getServer(memberId).thenCompose(listener -> listener.vote(request))).thenAccept(response -> this.send(this.localMemberId, () -> responseFuture.complete((VoteResponse)response), null)), responseFuture);
        return responseFuture;
    }

    public CompletableFuture<AppendResponse> append(MemberId memberId, AppendRequest request) {
        throw new UnsupportedOperationException("Cannot use old version in tests");
    }

    public CompletableFuture<AppendResponse> append(MemberId memberId, VersionedAppendRequest request) {
        CompletableFuture<AppendResponse> responseFuture = new CompletableFuture<AppendResponse>();
        this.send(memberId, () -> ((CompletableFuture)this.getServer(memberId).thenCompose(listener -> listener.append(request))).thenAccept(response -> this.send(this.localMemberId, () -> responseFuture.complete((AppendResponse)response), null)), responseFuture);
        return responseFuture;
    }

    public void registerTransferHandler(Function<TransferRequest, CompletableFuture<TransferResponse>> handler) {
        this.transferHandler = handler;
    }

    public void unregisterTransferHandler() {
        this.transferHandler = null;
    }

    public void registerConfigureHandler(Function<ConfigureRequest, CompletableFuture<ConfigureResponse>> handler) {
        this.configureHandler = handler;
    }

    public void unregisterConfigureHandler() {
        this.configureHandler = null;
    }

    public void registerReconfigureHandler(Function<ReconfigureRequest, CompletableFuture<ReconfigureResponse>> handler) {
        this.reconfigureHandler = handler;
    }

    public void unregisterReconfigureHandler() {
        this.reconfigureHandler = null;
    }

    public void registerForceConfigureHandler(Function<ForceConfigureRequest, CompletableFuture<ForceConfigureResponse>> handler) {
    }

    public void unregisterForceConfigureHandler() {
    }

    public void registerJoinHandler(Function<JoinRequest, CompletableFuture<JoinResponse>> handler) {
        this.joinHandler = handler;
    }

    public void unregisterJoinHandler() {
        this.joinHandler = null;
    }

    public void registerLeaveHandler(Function<LeaveRequest, CompletableFuture<LeaveResponse>> handler) {
        this.leaveHandler = handler;
    }

    public void unregisterLeaveHandler() {
        this.leaveHandler = null;
    }

    public void registerInstallHandler(Function<InstallRequest, CompletableFuture<InstallResponse>> handler) {
        this.installHandler = handler;
    }

    public void unregisterInstallHandler() {
        this.installHandler = null;
    }

    public void registerPollHandler(Function<PollRequest, CompletableFuture<PollResponse>> handler) {
        this.pollHandler = handler;
    }

    public void unregisterPollHandler() {
        this.pollHandler = null;
    }

    public void registerVoteHandler(Function<VoteRequest, CompletableFuture<VoteResponse>> handler) {
        this.voteHandler = handler;
    }

    public void unregisterVoteHandler() {
        this.voteHandler = null;
    }

    public void registerAppendV1Handler(Function<AppendRequest, CompletableFuture<AppendResponse>> handler) {
    }

    public void registerAppendV2Handler(Function<VersionedAppendRequest, CompletableFuture<AppendResponse>> handler) {
        this.appendHandler = handler;
    }

    public void unregisterAppendHandler() {
        this.appendHandler = null;
    }

    private CompletableFuture<ControllableRaftServerProtocol> getServer(MemberId memberId) {
        ControllableRaftServerProtocol server = this.server(memberId);
        if (server != null) {
            return CompletableFuture.completedFuture(server);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<AppendResponse> append(VersionedAppendRequest request) {
        if (this.appendHandler != null) {
            return this.appendHandler.apply(request);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<VoteResponse> vote(VoteRequest request) {
        if (this.voteHandler != null) {
            return this.voteHandler.apply(request);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<PollResponse> poll(PollRequest request) {
        if (this.pollHandler != null) {
            return this.pollHandler.apply(request);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<TransferResponse> transfer(TransferRequest request) {
        if (this.transferHandler != null) {
            return this.transferHandler.apply(request);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<InstallResponse> install(InstallRequest request) {
        if (this.installHandler != null) {
            return this.installHandler.apply(request);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<ReconfigureResponse> reconfigure(ReconfigureRequest request) {
        if (this.reconfigureHandler != null) {
            return this.reconfigureHandler.apply(request);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<ForceConfigureResponse> forceConfigure(ForceConfigureRequest request) {
        if (this.forceConfigureHandler != null) {
            return this.forceConfigureHandler.apply(request);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<JoinResponse> join(JoinRequest request) {
        if (this.joinHandler != null) {
            return this.joinHandler.apply(request);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<LeaveResponse> leave(LeaveRequest request) {
        if (this.leaveHandler != null) {
            return this.leaveHandler.apply(request);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }

    CompletableFuture<ConfigureResponse> configure(ConfigureRequest request) {
        if (this.configureHandler != null) {
            return this.configureHandler.apply(request);
        }
        return CompletableFuture.failedFuture(new ConnectException());
    }
}

