/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.RaftRequestMetrics;
import io.camunda.zeebe.test.util.junit.AutoCloseResources;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@AutoCloseResources
public class RaftRequestMetricsTest {
    @AutoCloseResources.AutoCloseResource
    private MeterRegistry meterRegistry = new SimpleMeterRegistry();
    @AutoCloseResources.AutoCloseResource
    private ExecutorService executorService = Executors.newWorkStealingPool();
    private final RaftRequestMetrics raftMetrics = new RaftRequestMetrics("1", this.meterRegistry);
    private final AtomicBoolean failed = new AtomicBoolean(false);

    @Test
    public void shouldBeThreadSafe() {
        ArrayList<Runnable> tasks = new ArrayList<Runnable>(20000);
        int i = 0;
        while (i < 20000) {
            int iFinal = i++;
            tasks.add(() -> {
                try {
                    this.raftMetrics.receivedMessage(String.valueOf(iFinal % 100));
                }
                catch (Exception e) {
                    this.failed.set(true);
                }
            });
            tasks.add(() -> {
                try {
                    this.raftMetrics.sendMessage(String.valueOf(iFinal % 5), String.valueOf(iFinal % 100));
                }
                catch (Exception e) {
                    this.failed.set(true);
                }
            });
        }
        tasks.forEach(this.executorService::submit);
        this.executorService.shutdown();
        Assertions.assertThat((boolean)this.failed.get()).isFalse();
    }
}

