/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft;

import io.atomix.cluster.MemberId;
import io.atomix.raft.ControllableRaftContexts;
import io.atomix.raft.RaftOperation;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCasesMode;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import net.jqwik.api.Provide;
import net.jqwik.api.ShrinkingMode;
import net.jqwik.api.lifecycle.AfterTry;
import net.jqwik.api.lifecycle.BeforeProperty;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomizedRaftTest {
    private static final int OPERATION_SIZE = 10000;
    private static final Logger LOG = LoggerFactory.getLogger(RandomizedRaftTest.class);
    private ControllableRaftContexts raftContexts;
    private List<RaftOperation> defaultOperations;
    private List<RaftOperation> operationsWithSnapshot;
    private List<RaftOperation> operationsWithRestarts;
    private List<RaftOperation> operationsWithSnapshotsAndRestarts;
    private List<RaftOperation> operationsWithSnapshotsAndRestartsWithDataLoss;
    private List<MemberId> raftMembers;
    private Path raftDataDirectory;

    @BeforeProperty
    public void initOperations() {
        List servers = IntStream.range(0, 3).mapToObj(String::valueOf).map(MemberId::from).collect(Collectors.toList());
        this.defaultOperations = RaftOperation.getDefaultRaftOperations();
        this.operationsWithSnapshot = RaftOperation.getRaftOperationsWithSnapshot();
        this.operationsWithRestarts = RaftOperation.getRaftOperationsWithRestarts();
        this.operationsWithSnapshotsAndRestarts = RaftOperation.getRaftOperationsWithSnapshotsAndRestarts();
        this.operationsWithSnapshotsAndRestartsWithDataLoss = RaftOperation.getRaftOperationsWithSnapshotsAndRestartsWithDataLoss();
        this.raftMembers = servers;
    }

    @AfterTry
    public void shutDownRaftNodes() throws IOException {
        this.raftContexts.shutdown();
        FileUtil.deleteFolder((Path)this.raftDataDirectory);
        this.raftDataDirectory = null;
    }

    @Property(tries=10, shrinking=ShrinkingMode.OFF, edgeCases=EdgeCasesMode.NONE)
    void consistencyTestWithNoSnapshot(@ForAll(value="raftOperations") List<RaftOperation> raftOperations, @ForAll(value="raftMembers") List<MemberId> raftMembers, @ForAll(value="seeds") long seed) throws Exception {
        this.consistencyTest(raftOperations, raftMembers, seed);
    }

    @Property(tries=10, shrinking=ShrinkingMode.OFF, edgeCases=EdgeCasesMode.NONE)
    void consistencyTestWithSnapshot(@ForAll(value="raftOperationsWithSnapshot") List<RaftOperation> raftOperations, @ForAll(value="raftMembers") List<MemberId> raftMembers, @ForAll(value="seeds") long seed) throws Exception {
        this.consistencyTest(raftOperations, raftMembers, seed);
    }

    @Property(tries=10, shrinking=ShrinkingMode.OFF, edgeCases=EdgeCasesMode.NONE)
    void consistencyTestWithRestarts(@ForAll(value="raftOperationsWithRestarts") List<RaftOperation> raftOperations, @ForAll(value="raftMembers") List<MemberId> raftMembers, @ForAll(value="seeds") long seed) throws Exception {
        this.consistencyTest(raftOperations, raftMembers, seed);
    }

    @Property(tries=10, shrinking=ShrinkingMode.OFF, edgeCases=EdgeCasesMode.NONE)
    void consistencyTestWithSnapshotsAndRestarts(@ForAll(value="raftOperationsWithSnapshotsAndRestarts") List<RaftOperation> raftOperations, @ForAll(value="raftMembers") List<MemberId> raftMembers, @ForAll(value="seeds") long seed) throws Exception {
        this.consistencyTest(raftOperations, raftMembers, seed);
    }

    @Property(tries=1, shrinking=ShrinkingMode.OFF, edgeCases=EdgeCasesMode.NONE)
    void consistencyTestAfterDataLoss(@ForAll(value="raftOperationsWithSnapshotsAndRestartsWithDataLoss") List<RaftOperation> raftOperations, @ForAll(value="raftMembers") List<MemberId> raftMembers, @ForAll(value="seeds") long seed) throws Exception {
        this.consistencyTest(raftOperations, raftMembers, seed);
    }

    @Property(tries=10, shrinking=ShrinkingMode.OFF, edgeCases=EdgeCasesMode.NONE)
    void livenessTestWithRestarts(@ForAll(value="raftOperationsWithRestarts") List<RaftOperation> raftOperations, @ForAll(value="raftMembers") List<MemberId> raftMembers, @ForAll(value="seeds") long seed) throws Exception {
        this.livenessTest(raftOperations, raftMembers, seed);
    }

    @Property(tries=10, shrinking=ShrinkingMode.OFF, edgeCases=EdgeCasesMode.NONE)
    void livenessTestWithRestartsAndSnapshots(@ForAll(value="raftOperationsWithSnapshotsAndRestarts") List<RaftOperation> raftOperations, @ForAll(value="raftMembers") List<MemberId> raftMembers, @ForAll(value="seeds") long seed) throws Exception {
        this.livenessTest(raftOperations, raftMembers, seed);
    }

    @Property(tries=10, shrinking=ShrinkingMode.OFF, edgeCases=EdgeCasesMode.NONE)
    void livenessTestWithNoSnapshot(@ForAll(value="raftOperations") List<RaftOperation> raftOperations, @ForAll(value="raftMembers") List<MemberId> raftMembers, @ForAll(value="seeds") long seed) throws Exception {
        this.livenessTest(raftOperations, raftMembers, seed);
    }

    @Property(tries=10, shrinking=ShrinkingMode.OFF, edgeCases=EdgeCasesMode.NONE)
    void livenessTestWithSnapshot(@ForAll(value="raftOperationsWithSnapshot") List<RaftOperation> raftOperations, @ForAll(value="raftMembers") List<MemberId> raftMembers, @ForAll(value="seeds") long seed) throws Exception {
        this.livenessTest(raftOperations, raftMembers, seed);
    }

    private void consistencyTest(List<RaftOperation> raftOperations, List<MemberId> raftMembers, long seed) throws Exception {
        this.setUpRaftNodes(new Random(seed));
        int step = 0;
        Iterator<MemberId> memberIter = raftMembers.iterator();
        for (RaftOperation operation : raftOperations) {
            MemberId member = memberIter.next();
            LOG.info("{} on {}", (Object)operation, (Object)member);
            operation.run(this.raftContexts, member);
            this.raftContexts.assertAtMostOneLeader();
            if (++step % 100 != 0) continue;
            this.raftContexts.assertAllLogsEqual();
            step = 0;
        }
        this.raftContexts.assertAllLogsEqual();
        this.raftContexts.assertNoGapsInLog();
        this.raftContexts.assertNoJournalAppendErrors();
        this.raftContexts.assertNoDataLoss();
    }

    private void livenessTest(List<RaftOperation> raftOperations, List<MemberId> raftMembers, long seed) throws Exception {
        this.setUpRaftNodes(new Random(seed));
        Iterator<MemberId> memberIter = raftMembers.iterator();
        for (RaftOperation operation : raftOperations) {
            MemberId member = memberIter.next();
            LOG.info("{} on {}", (Object)operation, (Object)member);
            operation.run(this.raftContexts, member);
        }
        this.raftContexts.assertAtMostOneLeader();
        this.raftContexts.assertAllLogsEqual();
        int maxStepsToReplicateEntries = 2000;
        while (!(this.raftContexts.hasLeaderAtTheLatestTerm() && this.raftContexts.hasReplicatedAllEntries() && this.raftContexts.hasCommittedAllEntries() || maxStepsToReplicateEntries-- <= 0)) {
            this.raftContexts.runUntilDone();
            this.raftContexts.processAllMessage();
            this.raftContexts.tickHeartbeatTimeout();
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.raftContexts.hasLeaderAtTheLatestTerm()).describedAs("Leader election should be completed if there are no messages lost.", new Object[0])).isTrue();
        this.raftContexts.assertAllMembersAreReady();
        this.raftContexts.assertAllLogsEqual();
        this.raftContexts.assertAllEntriesCommittedAndReplicatedToAll();
        this.raftContexts.assertNoGapsInLog();
        this.raftContexts.assertNoJournalAppendErrors();
        this.raftContexts.assertNoDataLoss();
    }

    @Provide
    Arbitrary<List<RaftOperation>> raftOperations() {
        Arbitrary operation = Arbitraries.of(this.defaultOperations);
        return operation.list().ofSize(10000);
    }

    @Provide
    Arbitrary<List<RaftOperation>> raftOperationsWithSnapshot() {
        Arbitrary operation = Arbitraries.of(this.operationsWithSnapshot);
        return operation.list().ofSize(10000);
    }

    @Provide
    Arbitrary<List<RaftOperation>> raftOperationsWithRestarts() {
        return Arbitraries.of(this.operationsWithRestarts).list().ofSize(10000);
    }

    @Provide
    Arbitrary<List<RaftOperation>> raftOperationsWithSnapshotsAndRestarts() {
        return Arbitraries.of(this.operationsWithSnapshotsAndRestarts).list().ofSize(10000);
    }

    @Provide
    Arbitrary<List<RaftOperation>> raftOperationsWithSnapshotsAndRestartsWithDataLoss() {
        return Arbitraries.of(this.operationsWithSnapshotsAndRestartsWithDataLoss).list().ofSize(10000);
    }

    @Provide
    Arbitrary<List<MemberId>> raftMembers() {
        Arbitrary members = Arbitraries.of(this.raftMembers);
        return members.list().ofSize(10000);
    }

    @Provide
    Arbitrary<Long> seeds() {
        return Arbitraries.longs();
    }

    private void setUpRaftNodes(Random random) throws Exception {
        this.raftDataDirectory = Files.createTempDirectory(null, new FileAttribute[0]);
        this.raftContexts = new ControllableRaftContexts(3);
        this.raftContexts.setup(this.raftDataDirectory, random);
    }
}

