/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.ManagedMessagingService;
import io.atomix.cluster.messaging.MessagingConfig;
import io.atomix.cluster.messaging.impl.NettyMessagingService;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.test.util.junit.AutoCloseResources;
import io.camunda.zeebe.test.util.socket.SocketUtil;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

@AutoCloseResources
class NettyMessagingServiceCompressionTest {
    @AutoCloseResources.AutoCloseResource
    private final MeterRegistry registry = new SimpleMeterRegistry();

    NettyMessagingServiceCompressionTest() {
    }

    @ParameterizedTest
    @EnumSource(value=MessagingConfig.CompressionAlgorithm.class)
    void shouldSendAndReceiveMessagesWhenCompressionEnabled(MessagingConfig.CompressionAlgorithm algorithm) {
        Address senderAddress = Address.from((int)SocketUtil.getNextAddress().getPort());
        MessagingConfig config = new MessagingConfig().setShutdownQuietPeriod(Duration.ofMillis(50L)).setCompressionAlgorithm(algorithm);
        ManagedMessagingService senderNetty = (ManagedMessagingService)new NettyMessagingService("test", senderAddress, config, this.registry).start().join();
        Address receiverAddress = Address.from((int)SocketUtil.getNextAddress().getPort());
        ManagedMessagingService receiverNetty = (ManagedMessagingService)new NettyMessagingService("test", receiverAddress, config, this.registry).start().join();
        String subject = "subject";
        String requestString = "message";
        String responseString = "success";
        receiverNetty.registerHandler("subject", (m, payload) -> {
            String message = new String((byte[])payload);
            Assertions.assertThat((String)message).isEqualTo("message");
            return CompletableFuture.completedFuture("success".getBytes());
        });
        CompletableFuture response = senderNetty.sendAndReceive(receiverAddress, "subject", "message".getBytes());
        byte[] result = (byte[])response.join();
        Assertions.assertThat((String)new String(result)).isEqualTo("success");
        senderNetty.stop();
        receiverNetty.stop();
    }
}

