/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.webapps.operate;

import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TreePath {
    private StringBuffer treePath;

    public TreePath() {
        this.treePath = new StringBuffer();
    }

    public TreePath(String treePath) {
        this.treePath = new StringBuffer(treePath);
    }

    public static String extractFlowNodeInstanceId(String treePath, String currentTreePath) {
        Pattern fniPattern = Pattern.compile(String.format("%s/FN_[^/]*/FNI_(\\d*)/.*", currentTreePath));
        Matcher matcher = fniPattern.matcher(treePath);
        matcher.matches();
        return matcher.group(1);
    }

    public TreePath startTreePath(String processInstanceId) {
        this.treePath = new StringBuffer(String.format("%s_%s", new Object[]{TreePathEntryType.PI, processInstanceId}));
        return this;
    }

    public TreePath startTreePath(long processInstanceKey) {
        return this.startTreePath(String.valueOf(processInstanceKey));
    }

    public TreePath appendFlowNode(String newEntry) {
        if (newEntry != null) {
            this.treePath.append(String.format("/%s_%s", new Object[]{TreePathEntryType.FN, newEntry}));
        }
        return this;
    }

    public TreePath appendFlowNode(int newEntry) {
        return this.appendFlowNode(String.valueOf(newEntry));
    }

    public TreePath appendFlowNodeInstance(String newEntry) {
        if (newEntry != null) {
            this.treePath.append(String.format("/%s_%s", new Object[]{TreePathEntryType.FNI, newEntry}));
        }
        return this;
    }

    public TreePath appendFlowNodeInstance(long newEntry) {
        return this.appendFlowNodeInstance(String.valueOf(newEntry));
    }

    public TreePath appendProcessInstance(String newEntry) {
        if (newEntry != null) {
            if (this.treePath == null || this.treePath.isEmpty()) {
                this.startTreePath(newEntry);
            } else {
                this.treePath.append(String.format("/%s_%s", new Object[]{TreePathEntryType.PI, newEntry}));
            }
        }
        return this;
    }

    public TreePath appendProcessInstance(long newEntry) {
        return this.appendProcessInstance(String.valueOf(newEntry));
    }

    public boolean isEmpty() {
        return this.treePath == null || this.treePath.isEmpty();
    }

    public TreePath appendEntries(String callActivityId, String flowNodeInstanceId, String processInstanceId) {
        return this.appendFlowNode(callActivityId).appendFlowNodeInstance(flowNodeInstanceId).appendProcessInstance(processInstanceId);
    }

    public String extractRootInstanceId() {
        Pattern piPattern = Pattern.compile("PI_(\\d*).*");
        Optional<Matcher> firstMatch = Arrays.stream(this.treePath.toString().split("/")).map(piPattern::matcher).filter(Matcher::matches).findFirst();
        if (firstMatch.isPresent()) {
            return firstMatch.get().group(1);
        }
        return null;
    }

    public List<String> extractProcessInstanceIds() {
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        Pattern piPattern = Pattern.compile("PI_(\\d*)$");
        Arrays.stream(this.treePath.toString().split("/")).map(piPattern::matcher).filter(Matcher::matches).forEach(matcher -> processInstanceIds.add(matcher.group(1)));
        return processInstanceIds;
    }

    public List<String> extractFlowNodeInstanceIds() {
        ArrayList<String> flowNodeInstanceIds = new ArrayList<String>();
        Pattern fniPattern = Pattern.compile("FNI_(\\d*)$");
        Arrays.stream(this.treePath.toString().split("/")).map(fniPattern::matcher).filter(Matcher::matches).forEach(matcher -> flowNodeInstanceIds.add(matcher.group(1)));
        return flowNodeInstanceIds;
    }

    public String toString() {
        return this.treePath.toString();
    }

    public TreePath removeProcessInstance(String processInstanceKey) {
        ArrayList treePathEntries = new ArrayList();
        Collections.addAll(treePathEntries, this.treePath.toString().split("/"));
        int piIndex = treePathEntries.indexOf("PI_" + processInstanceKey);
        if (piIndex > -1) {
            if (piIndex == treePathEntries.size() - 1) {
                treePathEntries.remove(piIndex);
            } else {
                treePathEntries.remove(piIndex + 2);
                treePathEntries.remove(piIndex + 1);
                treePathEntries.remove(piIndex);
            }
            this.treePath = new StringBuffer(String.join((CharSequence)"/", treePathEntries));
            return this;
        }
        return this;
    }

    public Optional<String> processInstanceForFni(String fniId) {
        int fniIndex;
        String compiled = this.treePath.toString();
        String[] pathSegments = compiled.split("/");
        for (int index = fniIndex = Arrays.asList(pathSegments).indexOf(StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"FNI_\u0001"}, (String)fniId)); index >= 0; --index) {
            String pathSegment = pathSegments[index];
            if (!pathSegment.startsWith("PI_")) continue;
            return Optional.of(pathSegment.replaceAll("PI_", ""));
        }
        return Optional.empty();
    }

    public static enum TreePathEntryType {
        PI,
        FNI,
        FN;

    }
}

