/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.webapps.backup.repository.opensearch;

import io.camunda.webapps.schema.descriptors.IndexTemplateDescriptor;
import java.util.List;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.core.GetRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.snapshot.CreateSnapshotRequest;
import org.opensearch.client.opensearch.snapshot.DeleteSnapshotRequest;
import org.opensearch.client.opensearch.snapshot.GetRepositoryRequest;
import org.opensearch.client.opensearch.snapshot.GetSnapshotRequest;

public interface OpensearchRequestDSL {
    private static String whereToSearch(IndexTemplateDescriptor template, QueryType queryType) {
        return switch (queryType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> template.getFullQualifiedName();
            case 1 -> template.getAlias();
        };
    }

    public static CreateSnapshotRequest.Builder createSnapshotRequestBuilder(String repository, String snapshot, List<String> indices) {
        return new CreateSnapshotRequest.Builder().repository(repository).snapshot(snapshot).indices(indices);
    }

    public static DeleteSnapshotRequest.Builder deleteSnapshotRequestBuilder(String repositoryName, String snapshotName) {
        return new DeleteSnapshotRequest.Builder().repository(repositoryName).snapshot(snapshotName);
    }

    public static GetRepositoryRequest.Builder repositoryRequestBuilder(String name) {
        return new GetRepositoryRequest.Builder().name(name, new String[0]);
    }

    public static SearchRequest.Builder searchRequestBuilder(String index) {
        return new SearchRequest.Builder().index(index, new String[0]);
    }

    public static SearchRequest.Builder searchRequestBuilder(IndexTemplateDescriptor template, QueryType queryType) {
        SearchRequest.Builder builder = new SearchRequest.Builder();
        builder.index(OpensearchRequestDSL.whereToSearch(template, queryType), new String[0]);
        return builder;
    }

    public static SearchRequest.Builder searchRequestBuilder(IndexTemplateDescriptor template) {
        return OpensearchRequestDSL.searchRequestBuilder(template, QueryType.ALL);
    }

    public static GetSnapshotRequest.Builder getSnapshotRequestBuilder(String repository, String snapshot) {
        return new GetSnapshotRequest.Builder().repository(repository).snapshot(snapshot, new String[0]);
    }

    public static GetRequest getRequest(String index, String id) {
        return new GetRequest.Builder().index(index).id(id).build();
    }

    public static Time time(String value) {
        return Time.of(b -> b.time(value));
    }

    public static enum QueryType {
        ONLY_RUNTIME,
        ALL;

    }
}

