/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.webapps.backup.repository.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch.indices.GetIndexRequest;
import co.elastic.clients.elasticsearch.indices.GetIndexResponse;
import co.elastic.clients.elasticsearch.snapshot.CreateSnapshotRequest;
import co.elastic.clients.elasticsearch.snapshot.CreateSnapshotResponse;
import co.elastic.clients.elasticsearch.snapshot.DeleteSnapshotResponse;
import co.elastic.clients.elasticsearch.snapshot.GetRepositoryResponse;
import co.elastic.clients.elasticsearch.snapshot.GetSnapshotRequest;
import co.elastic.clients.elasticsearch.snapshot.GetSnapshotResponse;
import co.elastic.clients.elasticsearch.snapshot.SnapshotInfo;
import co.elastic.clients.elasticsearch.snapshot.SnapshotShardFailure;
import co.elastic.clients.elasticsearch.snapshot.SnapshotSort;
import io.camunda.webapps.backup.BackupException;
import io.camunda.webapps.backup.BackupRepository;
import io.camunda.webapps.backup.BackupService;
import io.camunda.webapps.backup.BackupStateDto;
import io.camunda.webapps.backup.GetBackupStateResponseDetailDto;
import io.camunda.webapps.backup.GetBackupStateResponseDto;
import io.camunda.webapps.backup.Metadata;
import io.camunda.webapps.backup.repository.BackupRepositoryProps;
import io.camunda.webapps.backup.repository.SnapshotNameProvider;
import io.camunda.webapps.backup.repository.elasticsearch.MetadataMarshaller;
import io.camunda.webapps.backup.repository.elasticsearch.SnapshotState;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.SocketTimeoutException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchBackupRepository
implements BackupRepository {
    public static final String SNAPSHOT_MISSING_EXCEPTION_TYPE = "snapshot_missing_exception";
    private static final String REPOSITORY_MISSING_EXCEPTION_TYPE = "repository_missing_exception";
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchBackupRepository.class);
    private final ElasticsearchClient esClient;
    private final BackupRepositoryProps backupProps;
    private final SnapshotNameProvider snapshotNameProvider;
    private final Executor executor;

    public ElasticsearchBackupRepository(ElasticsearchClient esClient, BackupRepositoryProps backupProps, SnapshotNameProvider snapshotNameProvider, Executor executor) {
        this.esClient = esClient;
        this.backupProps = backupProps;
        this.snapshotNameProvider = snapshotNameProvider;
        this.executor = executor;
    }

    @Override
    public SnapshotNameProvider snapshotNameProvider() {
        return this.snapshotNameProvider;
    }

    @Override
    public void deleteSnapshot(String repositoryName, String snapshotName) {
        this.executor.execute(() -> {
            try {
                DeleteSnapshotResponse response = this.esClient.snapshot().delete(q -> q.repository(repositoryName).snapshot(snapshotName));
                LOGGER.debug("Delete snapshot was acknowledged by Elasticsearch node: {}", (Object)response.acknowledged());
            }
            catch (ElasticsearchException e) {
                if (this.isSnapshotMissingException((Exception)((Object)e))) {
                    LOGGER.warn("No snapshot found for snapshot deletion: {} ", (Object)e.getMessage());
                } else {
                    LOGGER.error("Exception occurred while deleting the snapshot: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void validateRepositoryExists(String repositoryName) {
        try {
            GetRepositoryResponse repository = this.esClient.snapshot().getRepository(r -> r.name(repositoryName, new String[0]));
            if (repository.result().isEmpty()) {
                String reason = String.format("No repository with name [%s] could be found.", repositoryName);
                throw new BackupException.MissingRepositoryException(reason);
            }
        }
        catch (IOException ex) {
            String reason = String.format("Encountered an error connecting to Elasticsearch while retrieving repository with name [%s].", repositoryName);
            throw new BackupException.BackupRepositoryConnectionException(reason, ex);
        }
        catch (ElasticsearchException e) {
            if (this.isRepositoryMissingException((Exception)((Object)e))) {
                String reason = String.format("No repository with name [%s] could be found.", repositoryName);
                throw new BackupException.MissingRepositoryException(reason);
            }
            String reason = String.format("Exception occurred when validating existence of repository with name [%s].", repositoryName);
            throw new BackupException(reason, (Exception)((Object)e));
        }
    }

    @Override
    public void validateNoDuplicateBackupId(String repositoryName, Long backupId) {
        try {
            GetSnapshotResponse response = this.esClient.snapshot().get(r -> r.repository(repositoryName).snapshot(this.snapshotNameProvider.getSnapshotNamePrefix(backupId) + "*", new String[0]));
            if (!response.snapshots().isEmpty()) {
                String reason = String.format("A backup with ID [%s] already exists. Found snapshots: [%s]", backupId, response.snapshots().stream().map(SnapshotInfo::snapshot).collect(Collectors.joining(", ")));
                throw new BackupException.InvalidRequestException(reason);
            }
        }
        catch (IOException ex) {
            String reason = String.format("Encountered an error connecting to Elasticsearch while searching for duplicate backup. Repository name: [%s].", repositoryName);
            throw new BackupException.BackupRepositoryConnectionException(reason, ex);
        }
        catch (ElasticsearchException e) {
            if (this.isSnapshotMissingException((Exception)((Object)e))) {
                return;
            }
            String reason = String.format("Exception occurred when validating whether backup with ID [%s] already exists.", backupId);
            throw new BackupException.BackupRepositoryConnectionException(reason, (Exception)((Object)e));
        }
    }

    @Override
    public GetBackupStateResponseDto getBackupState(String repositoryName, Long backupId) {
        List<SnapshotInfo> snapshots = this.findSnapshots(repositoryName, backupId);
        return this.getBackupResponse(backupId, snapshots);
    }

    @Override
    public Optional<Metadata> getMetadata(String repositoryName, Long backupId) {
        List<SnapshotInfo> snapshots = this.findSnapshots(repositoryName, backupId);
        if (snapshots.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.extractMetadata(snapshots.getFirst()));
    }

    @Override
    public Set<String> checkAllIndicesExist(List<String> indices) {
        try {
            GetIndexResponse response = this.esClient.indices().get(GetIndexRequest.of(b -> b.index(indices).ignoreUnavailable(Boolean.valueOf(true))));
            return response.result().keySet();
        }
        catch (IOException e) {
            throw new BackupException.BackupRepositoryConnectionException("Unable to connect to Elasticsearch", e);
        }
    }

    @Override
    public List<GetBackupStateResponseDto> getBackups(String repositoryName, boolean verbose, String pattern) {
        String validPattern;
        try {
            validPattern = BackupRepository.validPattern(pattern);
        }
        catch (IllegalArgumentException ex) {
            throw new BackupException.InvalidRequestException(ex.getMessage());
        }
        GetSnapshotRequest snapshotsStatusRequest = GetSnapshotRequest.of(b -> {
            b.repository(repositoryName).snapshot(this.snapshotNameProvider.snapshotNamePrefix() + validPattern, new String[0]).verbose(Boolean.valueOf(verbose));
            if (verbose) {
                b.sort(SnapshotSort.StartTime).order(SortOrder.Desc);
            }
            return b;
        });
        try {
            GetSnapshotResponse response = this.esClient.snapshot().get(snapshotsStatusRequest);
            List<SnapshotInfo> snapshots = response.snapshots();
            if (verbose) {
                snapshots = snapshots.stream().sorted(Comparator.comparing(SnapshotInfo::startTimeInMillis).reversed()).toList();
            }
            LinkedHashMap groupedSnapshotInfos = snapshots.stream().collect(Collectors.groupingBy(si -> {
                Metadata metadata = this.extractMetadata((SnapshotInfo)si);
                Long backupId = metadata.backupId();
                if (backupId == null) {
                    backupId = this.snapshotNameProvider.extractBackupId(si.snapshot());
                }
                return backupId;
            }, LinkedHashMap::new, Collectors.toList()));
            List<GetBackupStateResponseDto> responses = groupedSnapshotInfos.entrySet().stream().map(entry -> this.getBackupResponse((Long)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
            return responses;
        }
        catch (IOException ex) {
            String reason = String.format("Encountered an error connecting to Elasticsearch while searching for snapshots. Repository name: [%s].", repositoryName);
            throw new BackupException.BackupRepositoryConnectionException(reason, ex);
        }
        catch (Exception e) {
            if (this.isRepositoryMissingException(e)) {
                String reason = String.format("No repository with name [%s] could be found.", repositoryName);
                throw new BackupException.MissingRepositoryException(reason);
            }
            if (this.isSnapshotMissingException(e)) {
                return new ArrayList<GetBackupStateResponseDto>();
            }
            String reason = String.format("Exception occurred when searching for backups: %s", e.getMessage());
            throw new BackupException.BackupRepositoryConnectionException(reason, e);
        }
    }

    @Override
    public void executeSnapshotting(BackupService.SnapshotRequest snapshotRequest, Runnable onSuccess, Runnable onFailure) {
        CreateSnapshotRequest request = CreateSnapshotRequest.of(b -> b.repository(snapshotRequest.repositoryName()).snapshot(snapshotRequest.snapshotName()).indices(snapshotRequest.indices().allIndices()).ignoreUnavailable(Boolean.valueOf(false)).includeGlobalState(Boolean.valueOf(this.backupProps.includeGlobalState())).metadata(MetadataMarshaller.asJson(snapshotRequest.metadata(), this.esClient._jsonpMapper())).featureStates("none", new String[0]).waitForCompletion(Boolean.valueOf(true)));
        CreateSnapshotListener listener = new CreateSnapshotListener(snapshotRequest, onSuccess, onFailure);
        this.executor.execute(() -> {
            try {
                CreateSnapshotResponse response = this.esClient.snapshot().create(request);
                listener.onResponse(response);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private Metadata extractMetadata(SnapshotInfo si) {
        try {
            Metadata metadata = MetadataMarshaller.fromMetadata(si.metadata(), this.esClient._jsonpMapper());
            if (metadata == null || !metadata.isInitialized()) {
                metadata = this.snapshotNameProvider.extractMetadataFromSnapshotName(si.snapshot());
            }
            return metadata;
        }
        catch (RuntimeException e) {
            return this.snapshotNameProvider.extractMetadataFromSnapshotName(si.snapshot());
        }
    }

    private boolean isErrorType(Exception e, String errorType) {
        if (e instanceof ElasticsearchException) {
            String type = ((ElasticsearchException)((Object)e)).error().type();
            return Objects.equals(type, errorType);
        }
        return false;
    }

    private boolean isSnapshotMissingException(Exception e) {
        return this.isErrorType(e, SNAPSHOT_MISSING_EXCEPTION_TYPE);
    }

    private boolean isRepositoryMissingException(Exception e) {
        return this.isErrorType(e, REPOSITORY_MISSING_EXCEPTION_TYPE);
    }

    public List<SnapshotInfo> findSnapshots(String repositoryName, Long backupId) {
        GetSnapshotRequest snapshotsStatusRequest = GetSnapshotRequest.of(b -> b.repository(repositoryName).snapshot(this.snapshotNameProvider.getSnapshotNamePrefix(backupId) + "*", new String[0]));
        try {
            GetSnapshotResponse response = this.esClient.snapshot().get(snapshotsStatusRequest);
            if (response.snapshots().isEmpty()) {
                throw new BackupException.ResourceNotFoundException(String.format("No backup with id [%s] found.", backupId));
            }
            return response.snapshots();
        }
        catch (IOException ex) {
            String reason = String.format("Encountered an error connecting to Elasticsearch while searching for snapshots. Repository name: [%s].", repositoryName);
            throw new BackupException.BackupRepositoryConnectionException(reason, ex);
        }
        catch (ElasticsearchException e) {
            if (this.isSnapshotMissingException((Exception)((Object)e))) {
                throw new BackupException.ResourceNotFoundException(String.format("No backup with id [%s] found.", backupId));
            }
            if (this.isRepositoryMissingException((Exception)((Object)e))) {
                String reason = String.format("No repository with name [%s] could be found.", repositoryName);
                throw new BackupException(reason);
            }
            String reason = String.format("Exception occurred when searching for backup with ID [%s].", backupId);
            throw new BackupException(reason, (Exception)((Object)e));
        }
    }

    public boolean isSnapshotFinishedWithinTimeout(String repositoryName, String snapshotName) {
        int count = 0;
        long startTime = System.currentTimeMillis();
        int snapshotTimeout = this.backupProps.snapshotTimeout();
        long backupId = this.snapshotNameProvider.extractBackupId(snapshotName);
        while (snapshotTimeout == 0 || System.currentTimeMillis() - startTime <= (long)snapshotTimeout * 1000L) {
            List<SnapshotInfo> snapshotInfos = this.findSnapshots(repositoryName, backupId);
            SnapshotInfo currentSnapshot = snapshotInfos.stream().filter(x -> Objects.equals(x.snapshot(), snapshotName)).findFirst().orElse(null);
            if (currentSnapshot == null) {
                LOGGER.error("Expected (but not found) snapshot [{}] for backupId [{}].", (Object)snapshotName, (Object)backupId);
                return false;
            }
            if (Objects.equals(currentSnapshot.state(), SnapshotState.IN_PROGRESS.name())) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (++count % 600 != 0) continue;
                LOGGER.info("Waiting for snapshot [{}] to finish.", (Object)snapshotName);
                continue;
            }
            return this.snapshotWentWell(currentSnapshot);
        }
        LOGGER.error("Snapshot [{}] did not finish after configured timeout. Snapshot process won't continue.", (Object)snapshotName);
        return false;
    }

    private boolean snapshotWentWell(SnapshotInfo snapshotInfo) {
        if (snapshotInfo != null && Objects.equals(snapshotInfo.state(), SnapshotState.SUCCESS.name())) {
            LOGGER.info("Snapshot done: {}", (Object)snapshotInfo.snapshot());
            return true;
        }
        if (snapshotInfo != null && Objects.equals(snapshotInfo.state(), SnapshotState.FAILED.name())) {
            LOGGER.error("Snapshot taking failed for {}, reason {}", (Object)snapshotInfo.snapshot(), (Object)snapshotInfo.reason());
            return false;
        }
        LOGGER.warn("Snapshot state is {} for snapshot {}", (Object)(snapshotInfo != null ? snapshotInfo.state() : null), (Object)(snapshotInfo != null ? snapshotInfo.snapshot() : null));
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private GetBackupStateResponseDto getBackupResponse(Long backupId, List<SnapshotInfo> snapshots) {
        response = new GetBackupStateResponseDto(backupId);
        firstSnapshot = snapshots.getFirst();
        metadata = this.extractMetadata(firstSnapshot);
        expectedSnapshotsCount = metadata.partCount();
        if (snapshots.size() != expectedSnapshotsCount.intValue()) ** GOTO lbl-1000
        if (snapshots.stream().map((Function<SnapshotInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, state(), (Lco/elastic/clients/elasticsearch/snapshot/SnapshotInfo;)Ljava/lang/String;)()).allMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/lang/String;)Z)((String)SnapshotState.SUCCESS.name()))) {
            response.setState(BackupStateDto.COMPLETED);
        } else if (snapshots.stream().map((Function<SnapshotInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, state(), (Lco/elastic/clients/elasticsearch/snapshot/SnapshotInfo;)Ljava/lang/String;)()).anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getBackupResponse$12(java.lang.String ), (Ljava/lang/String;)Z)())) {
            response.setState(BackupStateDto.FAILED);
        } else if (snapshots.stream().map((Function<SnapshotInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, state(), (Lco/elastic/clients/elasticsearch/snapshot/SnapshotInfo;)Ljava/lang/String;)()).anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/lang/String;)Z)((String)"INCOMPATIBLE"))) {
            response.setState(BackupStateDto.INCOMPATIBLE);
        } else if (snapshots.stream().map((Function<SnapshotInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, state(), (Lco/elastic/clients/elasticsearch/snapshot/SnapshotInfo;)Ljava/lang/String;)()).anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/lang/String;)Z)((String)SnapshotState.IN_PROGRESS.name()))) {
            response.setState(BackupStateDto.IN_PROGRESS);
        } else if (snapshots.size() < expectedSnapshotsCount) {
            lastSnapshot = snapshots.getLast();
            if (lastSnapshot.startTimeInMillis() == null || this.isIncompleteCheckTimedOut(this.backupProps.incompleteCheckTimeoutInSeconds(), lastSnapshot.endTimeInMillis())) {
                response.setState(BackupStateDto.INCOMPLETE);
            } else {
                response.setState(BackupStateDto.IN_PROGRESS);
            }
        } else {
            response.setState(BackupStateDto.FAILED);
        }
        details = new ArrayList<GetBackupStateResponseDetailDto>();
        for (SnapshotInfo snapshot : snapshots) {
            detail = new GetBackupStateResponseDetailDto();
            detail.setSnapshotName(snapshot.snapshot());
            if (snapshot.startTimeInMillis() != null && snapshot.startTimeInMillis() > 0L) {
                detail.setStartTime(OffsetDateTime.ofInstant(Instant.ofEpochMilli(snapshot.startTimeInMillis()), ZoneId.systemDefault()));
            }
            if (snapshot.failures() != null && !snapshot.failures().isEmpty()) {
                detail.setFailures((String[])snapshot.failures().stream().map((Function<SnapshotShardFailure, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, reason(), (Lco/elastic/clients/elasticsearch/snapshot/SnapshotShardFailure;)Ljava/lang/String;)()).toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$getBackupResponse$13(int ), (I)[Ljava/lang/String;)()));
            }
            detail.setState(snapshot.state());
            details.add(detail);
        }
        response.setDetails(details);
        if (response.getState().equals((Object)BackupStateDto.FAILED)) {
            failureReason = null;
            failedSnapshots = snapshots.stream().filter((Predicate<SnapshotInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getBackupResponse$14(co.elastic.clients.elasticsearch.snapshot.SnapshotInfo ), (Lco/elastic/clients/elasticsearch/snapshot/SnapshotInfo;)Z)()).map((Function<SnapshotInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, snapshot(), (Lco/elastic/clients/elasticsearch/snapshot/SnapshotInfo;)Ljava/lang/String;)()).collect(Collectors.joining(", "));
            if (!failedSnapshots.isEmpty()) {
                failureReason = String.format("There were failures with the following snapshots: %s", new Object[]{failedSnapshots});
            } else {
                partialSnapshot = snapshots.stream().filter((Predicate<SnapshotInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getBackupResponse$15(co.elastic.clients.elasticsearch.snapshot.SnapshotInfo ), (Lco/elastic/clients/elasticsearch/snapshot/SnapshotInfo;)Z)()).map((Function<SnapshotInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, snapshot(), (Lco/elastic/clients/elasticsearch/snapshot/SnapshotInfo;)Ljava/lang/String;)()).collect(Collectors.joining(", "));
                if (!partialSnapshot.isEmpty()) {
                    failureReason = String.format("Some of the snapshots are partial: %s", new Object[]{partialSnapshot});
                } else if (snapshots.size() > expectedSnapshotsCount) {
                    failureReason = "More snapshots found than expected.";
                }
            }
            if (failureReason != null) {
                response.setFailureReason(failureReason);
            }
        }
        return response;
    }

    private static /* synthetic */ boolean lambda$getBackupResponse$15(SnapshotInfo s) {
        return Objects.equals(s.state(), SnapshotState.PARTIAL.name());
    }

    private static /* synthetic */ boolean lambda$getBackupResponse$14(SnapshotInfo s) {
        return Objects.equals(s.state(), SnapshotState.FAILED.name());
    }

    private static /* synthetic */ String[] lambda$getBackupResponse$13(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ boolean lambda$getBackupResponse$12(String s) {
        return SnapshotState.FAILED.name().equals(s) || SnapshotState.PARTIAL.name().equals(s);
    }

    public class CreateSnapshotListener {
        private final BackupService.SnapshotRequest snapshotRequest;
        private final long backupId;
        private final Runnable onSuccess;
        private final Runnable onFailure;

        public CreateSnapshotListener(BackupService.SnapshotRequest snapshotRequest, Runnable onSuccess, Runnable onFailure) {
            this.snapshotRequest = snapshotRequest;
            this.backupId = ElasticsearchBackupRepository.this.snapshotNameProvider.extractBackupId(snapshotRequest.snapshotName());
            this.onSuccess = onSuccess;
            this.onFailure = onFailure;
        }

        public void onResponse(CreateSnapshotResponse response) {
            if (ElasticsearchBackupRepository.this.snapshotWentWell(response.snapshot())) {
                this.onSuccess.run();
            } else {
                this.onFailure.run();
            }
        }

        public void onFailure(Exception ex) {
            if (ex instanceof SocketTimeoutException) {
                int snapshotTimeout = ElasticsearchBackupRepository.this.backupProps.snapshotTimeout();
                LOGGER.warn("Socket timeout while creating snapshot [{}] for backup id [{}]. Start waiting with polling timeout, {}", new Object[]{this.snapshotRequest.snapshotName(), this.backupId, snapshotTimeout == 0 ? "until completion." : "at most " + snapshotTimeout + " seconds."});
                if (ElasticsearchBackupRepository.this.isSnapshotFinishedWithinTimeout(this.snapshotRequest.repositoryName(), this.snapshotRequest.snapshotName())) {
                    this.onSuccess.run();
                } else {
                    this.onFailure.run();
                }
            } else {
                LOGGER.error("Exception while creating snapshot [{}] for backup id [{}].", new Object[]{this.snapshotRequest.snapshotName(), this.backupId, ex});
                this.onFailure.run();
            }
        }
    }
}

