/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.webapps.backup.repository.opensearch;

import io.camunda.webapps.backup.repository.opensearch.SnapshotState;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch.snapshot.SnapshotInfo;
import org.opensearch.client.opensearch.snapshot.SnapshotShardFailure;

public class OpenSearchSnapshotInfo {
    private String snapshot;
    private String uuid;
    private SnapshotState state;
    private List<SnapshotShardFailure> failures = List.of();
    private Long startTimeInMillis;
    private Long endTimeInMillis;
    private Map<String, JsonData> metadata = Map.of();

    public String getSnapshot() {
        return this.snapshot;
    }

    public OpenSearchSnapshotInfo setSnapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public String getUuid() {
        return this.uuid;
    }

    public OpenSearchSnapshotInfo setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public SnapshotState getState() {
        return this.state;
    }

    public OpenSearchSnapshotInfo setState(SnapshotState state) {
        this.state = state;
        return this;
    }

    public List<SnapshotShardFailure> getFailures() {
        return this.failures;
    }

    public OpenSearchSnapshotInfo setFailures(List<SnapshotShardFailure> failures) {
        this.failures = failures;
        return this;
    }

    public Long getStartTimeInMillis() {
        return this.startTimeInMillis;
    }

    public OpenSearchSnapshotInfo setStartTimeInMillis(Long startTimeInMillis) {
        this.startTimeInMillis = startTimeInMillis;
        return this;
    }

    public Long getEndTimeInMillis() {
        return this.endTimeInMillis;
    }

    public OpenSearchSnapshotInfo setEndTimeInMillis(Long endTimeInMillis) {
        this.endTimeInMillis = endTimeInMillis;
        return this;
    }

    public Map<String, JsonData> getMetadata() {
        return this.metadata;
    }

    public OpenSearchSnapshotInfo setMetadata(Map<String, JsonData> metadata) {
        this.metadata = metadata;
        return this;
    }

    public static OpenSearchSnapshotInfo fromResponse(SnapshotInfo snapshotInfo) {
        return new OpenSearchSnapshotInfo().setSnapshot(snapshotInfo.snapshot()).setUuid(snapshotInfo.uuid()).setState(SnapshotState.valueOf(snapshotInfo.state())).setStartTimeInMillis(snapshotInfo.startTimeInMillis() != null ? Long.parseLong(snapshotInfo.startTimeInMillis()) : 0L).setEndTimeInMillis(snapshotInfo.endTimeInMillis() != null ? Long.parseLong(snapshotInfo.endTimeInMillis()) : 0L).setMetadata(snapshotInfo.metadata()).setFailures(snapshotInfo.failures());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.snapshot, this.uuid, this.state, this.failures, this.startTimeInMillis, this.endTimeInMillis, this.metadata});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenSearchSnapshotInfo that = (OpenSearchSnapshotInfo)o;
        return Objects.equals(this.snapshot, that.snapshot) && Objects.equals(this.uuid, that.uuid) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.failures, that.failures) && Objects.equals(this.startTimeInMillis, that.startTimeInMillis) && Objects.equals(this.endTimeInMillis, that.endTimeInMillis) && Objects.equals(this.metadata, that.metadata);
    }

    public String toString() {
        return "SnapshotInfo{snapshot='" + this.snapshot + "', uuid='" + this.uuid + "', state='" + String.valueOf((Object)this.state) + "', failures=" + String.valueOf(this.failures) + ", startTimeInMillis=" + this.startTimeInMillis + ", endTimeInMillis=" + this.endTimeInMillis + ", metadata=" + String.valueOf(this.metadata) + "}";
    }
}

