/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.webapps.backup.repository.opensearch;

import io.camunda.webapps.backup.Metadata;
import java.util.Map;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpMapper;

public class MetadataMarshaller {
    public static Map<String, JsonData> asJson(Metadata metadata, JsonpMapper jsonpMapper) {
        return Map.of("backupId", JsonData.of((Object)metadata.backupId(), (JsonpMapper)jsonpMapper), "version", JsonData.of((Object)metadata.version(), (JsonpMapper)jsonpMapper), "partNo", JsonData.of((Object)metadata.partNo(), (JsonpMapper)jsonpMapper), "partCount", JsonData.of((Object)metadata.partCount(), (JsonpMapper)jsonpMapper));
    }

    public static Metadata fromMetadata(Map<String, JsonData> metadata, JsonpMapper jsonpMapper) {
        try {
            Long backupId = null;
            try {
                JsonData backupIdJsonData = metadata.get("backupId");
                if (backupIdJsonData != null) {
                    backupId = (Long)backupIdJsonData.to(Long.class, jsonpMapper);
                }
            }
            catch (NullPointerException backupIdJsonData) {
                // empty catch block
            }
            String version = (String)metadata.get("version").to(String.class, jsonpMapper);
            Integer partNo = (Integer)metadata.get("partNo").to(Integer.class, jsonpMapper);
            Integer partCount = (Integer)metadata.get("partCount").to(Integer.class, jsonpMapper);
            return new Metadata(backupId, version, partNo, partCount);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to deserialize metadata %s".formatted(metadata), e);
        }
    }
}

