/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.webapps.backup.repository;

import io.camunda.webapps.backup.BackupException;
import io.camunda.webapps.backup.Metadata;
import io.camunda.webapps.backup.repository.SnapshotNameProvider;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WebappsSnapshotNameProvider
implements SnapshotNameProvider {
    public static final String SNAPSHOT_NAME_PREFIX = "camunda_webapps_";
    private static final String SNAPSHOT_NAME_PATTERN = "{prefix}{version}_part_{index}_of_{count}";
    private static final String SNAPSHOT_NAME_PREFIX_PATTERN = "camunda_webapps_{backupId}_";
    private static final Pattern BACKUPID_PATTERN = Pattern.compile("camunda_webapps_(\\d*)_.*");
    private static final Pattern METADATA_PATTERN = Pattern.compile("camunda_webapps_(?<backupId>\\d+)_(?<version>[^_]+)_part_(?<index>\\d+)_of_(?<count>\\d+)");

    @Override
    public String getSnapshotNamePrefix(long backupId) {
        return SNAPSHOT_NAME_PREFIX_PATTERN.replace("{backupId}", String.valueOf(backupId));
    }

    @Override
    public String getSnapshotName(Metadata metadata) {
        return SNAPSHOT_NAME_PATTERN.replace("{prefix}", this.getSnapshotNamePrefix(metadata.backupId())).replace("{version}", metadata.version()).replace("{index}", "" + metadata.partNo()).replace("{count}", "" + metadata.partCount());
    }

    @Override
    public Long extractBackupId(String snapshotName) {
        Matcher matcher = BACKUPID_PATTERN.matcher(snapshotName);
        if (matcher.matches()) {
            return Long.valueOf(matcher.group(1));
        }
        throw new BackupException("Unable to extract backupId. Snapshot name: " + snapshotName);
    }

    @Override
    public Metadata extractMetadataFromSnapshotName(String snapshotName) {
        if (snapshotName == null) {
            return null;
        }
        Matcher matcher = METADATA_PATTERN.matcher(snapshotName);
        if (matcher.matches()) {
            Long backupId = Long.parseLong(matcher.group("backupId"));
            String version = matcher.group("version");
            Integer index = Integer.parseInt(matcher.group("index"));
            Integer count = Integer.parseInt(matcher.group("count"));
            return new Metadata(backupId, version, index, count);
        }
        throw new IllegalArgumentException("Unable to extract metadata. Snapshot name: " + snapshotName);
    }

    @Override
    public String snapshotNamePrefix() {
        return SNAPSHOT_NAME_PREFIX;
    }
}

