/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.webapps.backup;

import io.camunda.webapps.backup.BackupService;
import io.camunda.webapps.backup.GetBackupStateResponseDto;
import io.camunda.webapps.backup.Metadata;
import io.camunda.webapps.backup.repository.SnapshotNameProvider;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface BackupRepository {
    public static final Logger LOGGER = LoggerFactory.getLogger(BackupRepository.class);

    public SnapshotNameProvider snapshotNameProvider();

    public void deleteSnapshot(String var1, String var2);

    public void validateRepositoryExists(String var1);

    public void validateNoDuplicateBackupId(String var1, Long var2);

    public GetBackupStateResponseDto getBackupState(String var1, Long var2);

    public Optional<Metadata> getMetadata(String var1, Long var2);

    public Set<String> checkAllIndicesExist(List<String> var1);

    public List<GetBackupStateResponseDto> getBackups(String var1);

    public void executeSnapshotting(BackupService.SnapshotRequest var1, Runnable var2, Runnable var3);

    default public boolean isIncompleteCheckTimedOut(long incompleteCheckTimeoutInSeconds, long lastSnapshotFinishedTime) {
        long incompleteCheckTimeoutInMilliseconds = incompleteCheckTimeoutInSeconds * 1000L;
        try {
            long now = Instant.now().toEpochMilli();
            return now - lastSnapshotFinishedTime > incompleteCheckTimeoutInMilliseconds;
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't check incomplete timeout for backup. Return incomplete check is timed out", (Throwable)e);
            return true;
        }
    }
}

