/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.webapps.backup;

import java.util.Collection;

public sealed class BackupException
extends RuntimeException {
    public BackupException(String message) {
        super(message);
    }

    public BackupException(String message, Exception cause) {
        super(message, cause);
    }

    public static final class IndexNotFoundException
    extends BackupException {
        public IndexNotFoundException(Collection<String> missingIndices) {
            super(String.format("Missing indices: %s", missingIndices));
        }
    }

    public static final class MissingRepositoryException
    extends BackupException {
        public MissingRepositoryException(String message) {
            super(message);
        }
    }

    public static final class BackupRepositoryConnectionException
    extends BackupException {
        public BackupRepositoryConnectionException(String message, Exception cause) {
            super(message, cause);
        }

        public BackupRepositoryConnectionException(String message) {
            super(message);
        }
    }

    public static final class ResourceNotFoundException
    extends BackupException {
        public ResourceNotFoundException(String message) {
            super(message);
        }

        public ResourceNotFoundException(String message, Exception e) {
            super(message, e);
        }
    }

    public static final class InvalidRequestException
    extends BackupException {
        public InvalidRequestException(String message) {
            super(message);
        }
    }
}

