/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.webapps.backup;

import io.camunda.webapps.backup.BackupException;
import io.camunda.webapps.backup.BackupRepository;
import io.camunda.webapps.backup.BackupService;
import io.camunda.webapps.backup.DynamicIndicesProvider;
import io.camunda.webapps.backup.GetBackupStateResponseDto;
import io.camunda.webapps.backup.Metadata;
import io.camunda.webapps.backup.TakeBackupRequestDto;
import io.camunda.webapps.backup.TakeBackupResponseDto;
import io.camunda.webapps.backup.repository.BackupRepositoryProps;
import io.camunda.webapps.schema.descriptors.backup.BackupPriorities;
import io.camunda.webapps.schema.descriptors.backup.SnapshotIndexCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupServiceImpl
implements BackupService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackupServiceImpl.class);
    private final Executor threadPoolTaskExecutor;
    private final Queue<BackupService.SnapshotRequest> requestsQueue = new ConcurrentLinkedQueue<BackupService.SnapshotRequest>();
    private final BackupPriorities backupPriorities;
    private final BackupRepositoryProps backupProps;
    private final DynamicIndicesProvider dynamicIndicesProvider;
    private final BackupRepository repository;
    private final List<SnapshotIndexCollection> indexPatternsOrdered;

    public BackupServiceImpl(Executor threadPoolTaskExecutor, BackupPriorities backupPriorities, BackupRepositoryProps backupProps, BackupRepository repository, DynamicIndicesProvider dynamicIndicesProvider) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
        this.backupPriorities = backupPriorities;
        this.indexPatternsOrdered = backupPriorities.indicesSplitBySnapshot().toList();
        this.repository = repository;
        this.backupProps = backupProps;
        this.dynamicIndicesProvider = dynamicIndicesProvider;
    }

    @Override
    public void deleteBackup(Long backupId) {
        this.repository.validateRepositoryExists(this.backupProps.repositoryName());
        String repositoryName = this.backupProps.repositoryName();
        int count = this.indexPatternsOrdered.size();
        String version = this.getCurrentVersion();
        for (int index = 0; index < count; ++index) {
            String snapshotName = this.repository.snapshotNameProvider().getSnapshotName(new Metadata(backupId, version, index + 1, count));
            this.repository.deleteSnapshot(repositoryName, snapshotName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TakeBackupResponseDto takeBackup(TakeBackupRequestDto request) {
        this.repository.validateRepositoryExists(this.backupProps.repositoryName());
        this.repository.validateNoDuplicateBackupId(this.backupProps.repositoryName(), request.getBackupId());
        if (!this.requestsQueue.isEmpty()) {
            throw new BackupException.InvalidRequestException("Another backup is running at the moment");
        }
        Queue<BackupService.SnapshotRequest> queue = this.requestsQueue;
        synchronized (queue) {
            if (!this.requestsQueue.isEmpty()) {
                throw new BackupException.InvalidRequestException("Another backup is running at the moment");
            }
            return this.scheduleSnapshots(request);
        }
    }

    @Override
    public GetBackupStateResponseDto getBackupState(Long backupId) {
        return this.repository.getBackupState(this.backupProps.repositoryName(), backupId);
    }

    @Override
    public List<GetBackupStateResponseDto> getBackups() {
        return this.repository.getBackups(this.backupProps.repositoryName());
    }

    TakeBackupResponseDto scheduleSnapshots(TakeBackupRequestDto request) {
        String repositoryName = this.backupProps.repositoryName();
        int count = this.indexPatternsOrdered.size();
        ArrayList<String> snapshotNames = new ArrayList<String>();
        String version = this.getCurrentVersion();
        int index = 0;
        for (SnapshotIndexCollection indexCollection : this.indexPatternsOrdered) {
            Metadata metadata = new Metadata(request.getBackupId(), version, index++, count);
            String snapshotName = this.repository.snapshotNameProvider().getSnapshotName(metadata);
            if (index == count) {
                indexCollection = indexCollection.addSkippableIndices(this.dynamicIndicesProvider.getAllDynamicIndices());
            }
            BackupService.SnapshotRequest snapshotRequest = new BackupService.SnapshotRequest(repositoryName, snapshotName, indexCollection, metadata);
            this.requestsQueue.offer(snapshotRequest);
            LOGGER.debug("Snapshot scheduled: {}", (Object)snapshotName);
            snapshotNames.add(snapshotName);
        }
        this.scheduleNextSnapshot();
        return new TakeBackupResponseDto().setScheduledSnapshots(snapshotNames);
    }

    void scheduleNextSnapshot() {
        BackupService.SnapshotRequest nextRequest = this.requestsQueue.poll();
        if (nextRequest != null) {
            this.threadPoolTaskExecutor.execute(() -> this.repository.executeSnapshotting(nextRequest, false, this::scheduleNextSnapshot, this.requestsQueue::clear));
            LOGGER.debug("Snapshot picked for execution: {}", (Object)nextRequest);
        }
    }

    private String getCurrentVersion() {
        return this.backupProps.version().toLowerCase();
    }
}

