/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.util;

import io.camunda.client.api.command.ClientException;
import io.camunda.client.api.command.ProblemException;
import io.camunda.service.exception.ServiceException;
import java.net.SocketTimeoutException;

public abstract class ErrorHandlingUtils {
    public static final String INVALID_STATE = "INVALID_STATE";
    public static final String TASK_ALREADY_ASSIGNED = "TASK_ALREADY_ASSIGNED";
    public static final String TASK_IS_NOT_ACTIVE = "TASK_IS_NOT_ACTIVE";
    public static final String TASK_NOT_ASSIGNED = "TASK_NOT_ASSIGNED";
    public static final String TASK_NOT_ASSIGNED_TO_CURRENT_USER = "TASK_NOT_ASSIGNED_TO_CURRENT_USER";
    public static final String TASK_PROCESSING_TIMEOUT = "TASK_PROCESSING_TIMEOUT";
    public static final String TIMEOUT_ERROR_MESSAGE = "The request timed out while processing the task.";

    public static String getErrorMessageFromServiceException(ServiceException exception) {
        return switch (exception.getStatus()) {
            case ServiceException.Status.DEADLINE_EXCEEDED -> ErrorHandlingUtils.createErrorMessage(TASK_PROCESSING_TIMEOUT, TIMEOUT_ERROR_MESSAGE);
            case ServiceException.Status.INVALID_STATE -> ErrorHandlingUtils.createErrorMessage(ServiceException.Status.INVALID_STATE.name(), exception.getMessage());
            default -> exception.getMessage();
        };
    }

    public static String getErrorMessageFromClientException(ClientException exception) {
        ProblemException problemException;
        if (exception instanceof ProblemException && (problemException = (ProblemException)exception).details().getTitle().equals(INVALID_STATE)) {
            return ErrorHandlingUtils.createErrorMessage(problemException.details().getTitle(), problemException.details().getDetail());
        }
        if (exception.getCause() != null && exception.getCause().getCause() instanceof SocketTimeoutException) {
            return ErrorHandlingUtils.createErrorMessage(TASK_PROCESSING_TIMEOUT, TIMEOUT_ERROR_MESSAGE);
        }
        return exception.getMessage();
    }

    public static String createErrorMessage(String title, String detail) {
        return String.format("{ \"title\": \"%s\",\n  \"detail\": \"%s\"\n}\n", title, detail);
    }
}

