/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.tenant;

import io.camunda.security.auth.CamundaAuthentication;
import io.camunda.security.auth.CamundaAuthenticationProvider;
import io.camunda.security.configuration.SecurityConfiguration;
import io.camunda.security.reader.TenantAccess;
import io.camunda.security.reader.TenantAccessProvider;
import java.util.function.Function;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;

@Component
public class TenantService {
    private final CamundaAuthenticationProvider authenticationProvider;
    private final TenantAccessProvider tenantAccessProvider;
    private final SecurityConfiguration securityConfiguration;

    public TenantService(CamundaAuthenticationProvider authenticationProvider, TenantAccessProvider tenantAccessProvider, SecurityConfiguration securityConfiguration) {
        this.authenticationProvider = authenticationProvider;
        this.tenantAccessProvider = tenantAccessProvider;
        this.securityConfiguration = securityConfiguration;
    }

    public TenantAccess getAuthenticatedTenants() {
        return this.withAuthenticationOrDefaultResult(arg_0 -> ((TenantAccessProvider)this.tenantAccessProvider).resolveTenantAccess(arg_0), TenantAccess.wildcard(null));
    }

    public boolean isTenantValid(String tenantId) {
        return this.withAuthenticationOrDefaultResult(authentication -> this.tenantAccessProvider.hasTenantAccessByTenantId(authentication, tenantId).allowed(), true);
    }

    private <T> T withAuthenticationOrDefaultResult(Function<CamundaAuthentication, T> supplier, T defaultValue) {
        if (this.hasNoneRequestContext() || !this.isMultiTenancyEnabled()) {
            return defaultValue;
        }
        CamundaAuthentication currentAuthentication = this.authenticationProvider.getCamundaAuthentication();
        return supplier.apply(currentAuthentication);
    }

    public boolean isMultiTenancyEnabled() {
        return this.securityConfiguration.getMultiTenancy().isChecksEnabled();
    }

    private boolean hasNoneRequestContext() {
        return RequestContextHolder.getRequestAttributes() == null;
    }
}

